// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Procedures for editing the individual keys in a key ring.
//..........................................................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include "Tscmsg.h"
#include "Check.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	BOOL				bIsWin9x;
extern	HINSTANCE			hInst;
extern	HWND				hMainWindow;
extern	LPCTSTR				lpszAppName;
extern	LPCTSTR				lpKeyRingIcon;
extern	LPCTSTR				lpIconPointer;
extern	BOOL				bProcessInProgress;
extern	DWORD				dwIdxOffset1;
extern	DWORD				dwIdxOffset2;
extern	DWORD				dwIdxSize1;
extern	LPBYTE				lpKeyBuffer1;
extern	LPBYTE				lpKeyBuffer2;
extern	LPBYTE				lpKeyBuffer3;
extern	BYTE				KeySID;
extern	LPBYTE				lpIndexFile2;
extern	HANDLE				hIdxHandle2;
extern	BYTE				TypeKey;
extern	DWORD				dwPublicDeleted;
extern	DWORD				dwSecretDeleted;
extern	DWORD				dwSecretIds;
extern	DWORD				dwPublicIds;
extern	DWORD				dwPublicSigs;
extern	DWORD				dwOldHelpNumber;
extern	SEARCH_TEMPLATE		KeyIdSearch;
extern	LPCTSTR				lpszNullString;
extern	LPTSTR				lpszNA;
extern	BYTE				TempUserId[256];
extern	BYTE				TempSigId[256];
extern	BYTE				TempOwnerId[256];
extern	DWORD				dwRecordLength1;
extern	DWORD				dwRecordLength2;
extern	DWORD				dwN_Bytes;
extern	DWORD				dwN_Bits;
extern	DWORD				dwD_Bytes;
extern	DWORD				dwP_Bytes;
extern	DWORD				dwQ_Bytes;
extern	DWORD				dwU_Bytes;
extern	DWORD				dwE_Bytes;
extern	BYTE				D_Temp;
extern	BYTE				Prime_P;
extern	BYTE				Prime_Q;
extern	BYTE				U_Temp;
extern	BYTE				E_Temp;
extern	BYTE				Modulus_N;
extern	UINT				uiGetPassPhraseMsg;
extern	int					iLengthOfPassPhrase;
extern	TCHAR				szPassPhrase1[250];
extern	TCHAR				szPassPhrase2[250];
extern	DWORD				dwPublicComp;
extern	DWORD				dwSignatureSize;
extern	TCHAR				szUserID[256];
extern	int					iLengthOfUserId;
extern	TCHAR				szPublicRingKeyId;
extern	HANDLE				hPublicRingKeyId;
extern	K_IDX_FMT			KeyIdIndex2;
extern	HWND				hDialogModeLess;
extern	int					iSkipCounter;
extern	int					iInitialSkipValue;
extern	BOOL				bCancelOperation;
extern	HWND				hDlgCurrent;
extern	HANDLE				hPublicKeyRing;
extern	HANDLE				hSecretKeyRing;
extern	HANDLE				hKeyHandle1;
extern	HANDLE				hKeyHandle2;
extern	LPBYTE				lpRingFile1;
extern	LPBYTE				lpRingFile2;
extern	DWORD				dwRingFileOffset1;
extern	DWORD				dwRingFileOffset2;
extern	LPVOID				lpIdxBuffer1;
extern	BOOL				bUniversalSet;
extern	BOOL				bAa;
extern	BOOL				bRestrictionsInEffect;
extern	DWORD				dwCompromiseSigs;
extern	DWORD				dwTip;
extern	DWORD				dwTipString;
extern	DWORD				dwTipHelp;
extern	BOOL				bChatKeySet;
extern	LPBYTE				lpKeyBufferDup1;
extern	LPBYTE				lpKeyBufferDup2;
extern	HFONT				hDlgFont;
extern	TCHAR				szMyDiary[MAX_PATH];
extern	TCHAR				szDiaryID[];
extern	DIARYEND			DiaryEnd;
extern	DIARYHDR			DiaryHdr;
extern	TCHAR				szDiaryId[];
extern	TCHAR				szJrlPassWord[MAX_PATH];
extern	BOOL				bJustCreated;
extern	TCHAR				szRoot[16];
extern	LPTSTR				lpMyCmdLine;
extern	BOOL				bSignedIn;
extern	BOOL				bLogo;
extern	TCHAR				szPassWord1[MAX_PATH];
extern	TCHAR				szPassWord2[MAX_PATH];
extern	TCHAR				szTemp[MAX_PATH];
extern	TCHAR				szTemp1[MAX_PATH];
extern	TCHAR				szTemp2[MAX_PATH];
extern	CONFIG				cfg;

// Variables for use by the edit and central directory procedures.
//................................................................
TCHAR			PubKey[]		= "Public";
TCHAR			SecKey[]		= "Secret";
TCHAR			Signature[]		= "  Signature";
TCHAR			szYes[]			= "Yes";
TCHAR			szNo[]			= "No";
TCHAR			szUnknownSig[]	= "Unknown Signature Owner";

LPCD_STRUCT		lpScratchCentralDir;
LPCD_STRUCT		lpScratchCentralDir1;
LPCD_STRUCT		lpPublicKeyCentralDir;
LPCD_STRUCT		lpSecretKeyCentralDir;

CD_STRUCT		CDLine;
CD_STRUCT		CDLine1;

HIMAGELIST		hImageListSmall;

// Number representation of edit function we will be doing.
//.........................................................
DWORD			dwEditFunction;

// Other variables used by the edit functions.
//............................................
BOOL			bKeysEdited;
BOOL			bMaterialAdded;
BOOL			bDoBackup;
BOOL			bWeChangedIt;
DWORD			MarkType;
HANDLE			hEditEvent;
HANDLE			hEditOpen;
BOOL			bSingleSelectionOnly;
int				iItemCount;
int				iItemsSelected;
int				iMaxItems;
LPCTSTR			lpszEditKeyRings = "EditKeyRings";
HWND			hEditWindow;
HWND			hEditListWindow;
BOOL			bEditWindowDisplayed = FALSE;
DWORD			dwCDLength;
UINT			uiCalcsMessage;
BYTE			UserId[256];

typedef BOOL (*EditProc)();

// Edit function call table. We have to use assembly language
// to call the functions in the table.
//...........................................................
EditProc	EditFunctions[]	 = {SetOwnerTrust,
							    DeleteSignatures,
							    DeleteKeys,
							    ExtractKeys,
							    SignAPublicKey,
							    DisableAKey,
							    AddUserId,
							    ChangePassPhrase,
							    DeleteKeys,
							    ExtractKeys,
							    IssueCompromiseCertificate,
								NULL,
								NULL,
								ExportPublicKey,
								SetUniversalKey,
								SetTheChatKey,
								ExportPublicKey,
								ViewKeyFingerprint,
								NewDiary};

// Register the window class to use for editing key rings.
//........................................................
BOOL RegisterEditWindow()
{
	WNDCLASS	wc;

	wc.style		 = 0;
	wc.lpfnWndProc	 = (WNDPROC)EditWndProc;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = hInst;
	wc.hIcon		 = LoadIcon(hInst,lpKeyRingIcon);
	wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
    wc.lpszMenuName  = NULL;              
    wc.lpszClassName = lpszEditKeyRings;
	
	if (bIsWin9x)
	{
		if (!RegisterWin95(&wc))
		{
			return(FALSE);
		}
	}
	else if (!RegisterClass(&wc))
	{
		return(FALSE);
	}
	return(TRUE);
}

// Window procedure for processing messages for the edit key ring 
// window and its virtual list box.
//...............................................................
LRESULT CALLBACK EditWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	int			iResult;

	switch(uMsg)
	{
		case WM_CREATE:
		{
			HMENU			hEditWinMenu;
			MENUITEMINFO	mii;
			TCHAR			szMenuTitle[64];
			LPCD_STRUCT		lpCentralDir1;

			// Disable the move menu item on the window menu.
			//...............................................
			hEditWinMenu = GetSystemMenu(hWnd,FALSE);

			ZeroMemory(&mii,sizeof(MENUITEMINFO));
			mii.cbSize = sizeof(MENUITEMINFO);
			mii.fMask = MIIM_ID | MIIM_STATE;
			mii.fState = MFS_GRAYED;
			mii.wID = -10;
			SetMenuItemInfo(hEditWinMenu,SC_MOVE,FALSE,&mii);

			// Set the title for the window. Use the title of
			// the edit procedure we will be doing.
			//...............................................
			if (dwEditFunction == 13)
			{
				LoadString(hInst,IDS_EXPORTPUBLICKEY,szMenuTitle,sizeof(szMenuTitle));
			}
			else if (dwEditFunction == 14)
			{
				LoadString(hInst,IDS_SETMYUKEY,szMenuTitle,sizeof(szMenuTitle));
			}
			else if (dwEditFunction == 15)
			{
				LoadString(hInst,IDS_SETMYCHATKEY,szMenuTitle,sizeof(szMenuTitle));
			}
			else if (dwEditFunction == 16)
			{
				LoadString(hInst,IDS_EXPORTSECRETKEY,szMenuTitle,sizeof(szMenuTitle));
			}
			else if (dwEditFunction == 17)
			{
				LoadString(hInst,IDS_KEYFINGERPRINT,szMenuTitle,sizeof(szMenuTitle));
			}
			else if (dwEditFunction == 18)
			{
				LoadString(hInst,IDS_NEWDIARY,szMenuTitle,sizeof(szMenuTitle));
			}
			else if (dwEditFunction == 19)
			{
				LoadString(hInst,IDS_RECIPSEMAIL,szMenuTitle,sizeof(szMenuTitle));
			}
			else
			{
				LoadString(hInst,dwEditFunction + EDITTITLESTART,
						   szMenuTitle,sizeof(szMenuTitle));
			}
			SetWindowText(hWnd,szMenuTitle);

			// Set the focus on the first key or signature.
			//.............................................
			if (MarkType == MARK_KEYS)
			{
				lpScratchCentralDir->STATE = LVIS_FOCUSED;
			}
			else
			{
				lpCentralDir1 = lpScratchCentralDir;

				while(TRUE)
				{
					if (lpCentralDir1->TYPE_KEY == SIG_PACKET)
					{
						break;
					}
					__asm
					{
						mov		eax,lpCentralDir1
						add		eax,dwCDLength
						mov		lpCentralDir1,eax
					}
				}
				lpCentralDir1->STATE = LVIS_FOCUSED;
			}
			// Setup the virtual list view window.
			//....................................
			hEditListWindow = CreateEditListView(hWnd);
			if (!hEditListWindow)
			{
				return(-1);
			}
			SetFocus(hEditListWindow);
			bEditWindowDisplayed = TRUE;
		}
		break;

		case WM_SIZE:
		{
			// Resize the virtual list view window.
			//.....................................
			ResizeEditListView(GetDlgItem(hWnd,IDC_EDITLISTVIEW),hWnd);
		}
		break;

		case WM_NOTIFY:
		{
			return(EditListViewNotify(hWnd,(LPNMHDR)lParam));
		}

		case WM_USER:
		{
			SetFocus(hEditListWindow);
		}
		break;

		case WM_TIP:
		{
			dwTipHelp = ChangeHelpTopic(IDH_VLEDITSELECTION);

			iResult = DialogBox(hInst,TEXT("TSCGTIP"),hEditListWindow,(DLGPROC)TscgTipProc);

			EmptyTheMessageQue();

			// See if we had a system error in creating the dialog box.
			//.........................................................
			if (iResult == -1)
			{
				ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
			}
			ChangeHelpTopic(dwTipHelp);
		}
		break;

		case WM_CLOSE:
		{
			DestroyWindow(hWnd);
		}
		break;

		case WM_DESTROY:
		{
			ImageList_Destroy(hImageListSmall);

			// Notify the mark keys procedure that it can
			// return.
			//...........................................
			SetEvent(hEditEvent);
			bEditWindowDisplayed = FALSE;
		}
		break;

        default:
			return(DefWindowProc(hWnd, uMsg, wParam, lParam));
	}
	return(0L);
}

// Create the virtual list view window for our edit procedures.
//.............................................................
HWND CreateEditListView(HWND hWndParent)
{
	DWORD       dwStyle;
	HWND        hWndListView;
	LVCOLUMN	lvColumn;
	HICON		hIcon;
	WORD		wIcon;
	int			i;
	TCHAR		szColumns[6][24] = {TEXT("    Type"),
									TEXT("Bits"),
									TEXT("Key ID"),
									TEXT("Date"),
									TEXT("Disabled"),
									TEXT("User or Signature ID")};

	int			iColumnSize[6] = {90,50,80,110,80,350};

	dwStyle =   WS_TABSTOP | 
				WS_CHILD | 
				WS_BORDER | 
				WS_VISIBLE |
				LVS_NOSORTHEADER |
				LVS_REPORT | 
				LVS_OWNERDATA;

	// Setup the last column depending on the screen size.
	//....................................................
	i = GetSystemMetrics(SM_CXFULLSCREEN);

	if (i >= 950)
	{
		iColumnSize[5] = 575;
	}
	// Set the style to single selection if required.
	//...............................................
	if (bSingleSelectionOnly)
	{
		dwStyle |= LVS_SINGLESEL;
	}
            
	hWndListView = CreateWindowEx(WS_EX_CLIENTEDGE,WC_LISTVIEW,NULL,
                                  dwStyle,0,0,0,0,hWndParent,
                                  (HMENU)IDC_EDITLISTVIEW,hInst,NULL);

	if(!hWndListView)
	{
		return(0);
	}
	SetFocus(hWndListView);

	// Set the extended styles for the virtual list box.
	//..................................................
	ListView_SetExtendedListViewStyleEx(hWndListView,0,
		                                LVS_EX_FULLROWSELECT |
										LVS_EX_ONECLICKACTIVATE | LVS_EX_GRIDLINES |
										LVS_EX_UNDERLINEHOT);

	// Resize the window to fit in the parent windows.
	//................................................
	ResizeEditListView(hWndListView, hWndParent);

	// Set the header columns for the virtual list view window.
	//.........................................................
	lvColumn.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
	for(i = 0; i < 6; i++)
	{
		if (i == 1)
		{
			lvColumn.fmt = LVCFMT_RIGHT;
		}
		else if (i == 2 || i == 3 || i == 4)
		{
			lvColumn.fmt = LVCFMT_CENTER;
		}
		else
		{
			lvColumn.fmt = LVCFMT_LEFT;
		}

		lvColumn.pszText = szColumns[i];
		lvColumn.cx = iColumnSize[i];
		SendMessage(hWndListView,LVM_INSERTCOLUMN,(WPARAM)i,(LPARAM)&lvColumn);
	}
	// Empty the list.
	//................
	SendMessage(hWndListView,LVM_DELETEALLITEMS,0,0);

	// Create the image list for the control.
	//.......................................
	hImageListSmall = ImageList_Create(16,16,ILC_MASK,ICONS_MAX,0);
			
	if (hImageListSmall)
	{
		// Load the icons to use for the messages.
		//........................................
		wIcon = KEY_ICONS_BASE;

		for (i = 0; i < KEY_ICONS_MAX; i++)
		{
			hIcon = LoadImage(hInst,MAKEINTRESOURCE(wIcon),IMAGE_ICON,16,16,LR_VGACOLOR);
			ImageList_AddIcon(hImageListSmall,hIcon);
			DestroyIcon(hIcon);
			wIcon++;
		}
		ListView_SetImageList(hWndListView,hImageListSmall,LVSIL_SMALL);
	}
	// Set the number of items in the list.
	//.....................................
	SendMessage(hWndListView,LVM_SETITEMCOUNT,(WPARAM)iItemCount, 
		       (LPARAM)LVSICF_NOINVALIDATEALL);

	// Set the callback mask so we can control the state information.
	//...............................................................
	SendMessage(hWndListView,LVM_SETCALLBACKMASK,(WPARAM)LVIS_SELECTED | LVIS_FOCUSED,0);

	return(hWndListView);
}

// Resize the virtual list view window for the edit procedures.
//.............................................................
VOID ResizeEditListView(HWND hWndListView, HWND hWndParent)
{
	RECT  rc;

	GetClientRect(hWndParent,&rc);

	MoveWindow(hWndListView,rc.left,rc.top,rc.right - rc.left,rc.bottom - rc.top,TRUE);
}

// Setup for and edit a key ring.
//...............................
VOID EditTheKeyRing()
{
	LARGE_INTEGER	li;
	DWORD			dwBytesRead;
	DWORD			dwCtb_Byte;
	BOOL			bResult;
	DWORD			dwSecretElements;
	DWORD			dwCDStructLength;
	int				iKeysSigsSelected;
	
	// We have a process in progress.
	//...............................
	bProcessInProgress = TRUE;

	dwCDLength = sizeof(CD_STRUCT);

	// Setup the proper help topic for editing the key ring.
	//......................................................
	if (dwEditFunction == 13)
	{
		dwOldHelpNumber = ChangeHelpTopic(IDH_EXPORTPUBLICKEY);
	}
	else if (dwEditFunction == 14)
	{
		dwOldHelpNumber = ChangeHelpTopic(IDH_SETUNIVERSALKEY);
	}
	else if (dwEditFunction == 15)
	{
		dwOldHelpNumber = ChangeHelpTopic(IDH_SET_CHAT_KEY);
	}
	else if (dwEditFunction == 16)
	{
		dwOldHelpNumber = ChangeHelpTopic(IDH_EXPORT_SECRET);
	}
	else if (dwEditFunction == 17)
	{
		dwOldHelpNumber = ChangeHelpTopic(IDH_KEY_FINGERPRINT);
	}
	else if (dwEditFunction == 18)
	{
		dwOldHelpNumber = ChangeHelpTopic(IDH_NEW_DIARY);
	}
	else
	{
		dwOldHelpNumber = ChangeHelpTopic(dwEditFunction + EDIT_KEY_RING_BASE);
	}
	bKeysEdited = FALSE;
	dwPublicDeleted = 0;
	dwSecretDeleted = 0;
	bMaterialAdded = FALSE;
	bWeChangedIt = FALSE;
	bDoBackup = FALSE;
	dwSecretElements = dwSecretIds;
	dwCDStructLength = sizeof(CD_STRUCT);

	// Allocate memory for the three buffers we will use and the
	// central directories for the public and secret key rings.
	//..........................................................
	lpKeyBuffer1 = AllocateMemory(SIZE_KEY_BUFF);
	lpKeyBuffer2 = AllocateMemory(SIZE_KEY_BUFF);
	lpKeyBuffer3 = AllocateMemory(SIZE_KEY_BUFF);
	lpSecretKeyCentralDir = AllocateMemory(dwSecretIds * sizeof(CD_STRUCT));
	lpPublicKeyCentralDir = AllocateMemory((dwPublicIds + dwPublicSigs - dwCompromiseSigs) * sizeof(CD_STRUCT));

	if (!lpKeyBuffer1 || !lpKeyBuffer2 || !lpKeyBuffer3 ||
		!lpSecretKeyCentralDir || !lpPublicKeyCentralDir)
	{
		goto EditError;
	}
	// Build the central directory for the secret key ring.
	// Use the user id index in group one to keep the keys
	// in order. 
	//....................................................
	SetUpGroup(SECRET_KEY,INDEX_UID,GROUP_ONE);
	bResult = BuildCentralDirectory(lpSecretKeyCentralDir,TRUE);
	if (!bResult)
	{
		goto EditError;
	}
	// Build the central directory for the public key ring.
	// Use the user id index in group one to keep the keys
	// in order. Use group two for the key id index.
	//.....................................................
	SetUpGroup(PUBLIC_KEY,INDEX_UID,GROUP_ONE);
	SetUpGroup(PUBLIC_KEY,INDEX_KEY,GROUP_TWO);
	bResult = BuildCentralDirectory(lpPublicKeyCentralDir,TRUE);
	if (!bResult)
	{
		goto EditError;
	}
	// Make a quick check to mark the secret keys as disabled or not.
	//...............................................................
	lpScratchCentralDir = lpSecretKeyCentralDir;
	while(dwSecretElements != 0)
	{
		// Search for the corresponding public key so we can check
		// if the secret key is disabled.
		//........................................................
		CopyMemory(&KeySID,lpScratchCentralDir->KEY_SIG_ID,KEY_ID_SIZE);

		li.QuadPart = SearchMyFileBinary(lpIndexFile2,&KeySID,KEY_ID_SIZE,hIdxHandle2,
										 0,&KeyIdSearch);
		if (li.QuadPart == -1)
		{
			goto EditError;
		}
		if (li.QuadPart != 0)
		{
			// We had a match. See if the public/secret key pair
			// is disabled.
			//..................................................
			dwIdxOffset2 = li.HighPart;
			dwBytesRead = ReadIndex2();
			if (dwBytesRead == -1)
			{
				goto EditError;
			}
			dwBytesRead = ReadRecord2();
			if (dwBytesRead == -1)
			{
				goto EditError;
			}
			// The public key is in lpKeyBuffer2.
			//...................................
			lpKeyBufferDup2 = lpKeyBuffer2;

			__asm
			{
				mov		edi,lpKeyBufferDup2
				mov		cl,byte ptr [edi]
				mov		dwCtb_Byte,ecx
			}
			GetPcktLength(lpKeyBufferDup2,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup2
				add		edi,CTB_SIZE
				add		edi,edx
				add		edi,eax
				mov		cl,byte ptr [edi]
				mov		dwCtb_Byte,ecx
				mov		lpKeyBufferDup2,edi
			}
			GetPcktLength(lpKeyBufferDup2,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup2
				add		edi,CTB_SIZE
				add		edi,edx
				mov		lpKeyBufferDup2,edi
			}
			// If the key is disabled, move Yes to the disabled field.
			//........................................................
			if (*lpKeyBufferDup2 & DISABLED_BIT)
			{
				CopyMemory(lpScratchCentralDir->DISABLED,szYes,lstrlen(szYes));
			}
		}
		__asm
		{
			mov		eax,dwCDStructLength
			add		lpScratchCentralDir,eax
		}
		dwSecretElements--;
	}	// while(dwSecretElements !=0)

	// If we are editing a secret key ring setup group one for the
	// secret key and group 2 for the public key.
	//............................................................
	if (TypeKey == SECRET_KEY)
	{
		SetUpGroup(SECRET_KEY,INDEX_UID,GROUP_ONE);
		SetUpGroup(PUBLIC_KEY,INDEX_UID,GROUP_TWO);
	}
	else
	{
		// We have a public key ring. Setup group one for the
		// public key and group two for the secret key.
		//...................................................
		SetUpGroup(PUBLIC_KEY,INDEX_UID,GROUP_ONE);
		SetUpGroup(SECRET_KEY,INDEX_UID,GROUP_TWO);
	}
	// Flush and rewind all the files.
	//................................
	bResult = FlushAllFiles();
	if (!bResult)
	{
		goto EditError;
	}
	bResult = RewindAllKeyRingFiles();
	if (!bResult)
	{
		goto EditError;
	}
	// Mark the keys we want to edit.
	//...............................
	bSingleSelectionOnly = FALSE;

	// If we are exporting a key to the clipboad or setting the
	// the universal key or setting the chat key, only one at a time.
	//...............................................................
	if (dwEditFunction == 13 || dwEditFunction == 14 || dwEditFunction == 15 ||
		dwEditFunction == 18)
	{
		bSingleSelectionOnly = TRUE;
	}
	iItemsSelected = 0;

	// Setup the central directory address and maximum item count
	// for the virtual list window.
	//...........................................................
	if (TypeKey == PUBLIC_KEY)
	{
		lpScratchCentralDir = lpPublicKeyCentralDir;
		iItemCount = (dwPublicIds + dwPublicSigs - dwCompromiseSigs);
	}
	else
	{
		lpScratchCentralDir = lpSecretKeyCentralDir;
		iItemCount = dwSecretIds;
	}
	// Set the type of entries to mark, keys or signatures.
	//.....................................................
	MarkType = MARK_KEYS;
	if (TypeKey == PUBLIC_KEY && dwEditFunction == 1)
	{
		MarkType = MARK_SIGS;
	}
	// Set the maximum number of items that can be selected.
	//......................................................
	if (TypeKey == PUBLIC_KEY)
	{
		if (MarkType == MARK_KEYS)
		{
			iMaxItems = dwPublicIds;
		}
		else
		{
			iMaxItems = (dwPublicSigs - dwCompromiseSigs);
		}
	}
	else
	{
		iMaxItems = dwSecretIds;
	}

	bResult = MarkTheKeys();
	if (!bResult)
	{
		goto EditError;
	}
	// We have to be able to use the default variables in
	// selecting a secret key to sign a public key with.
	//...................................................
	iKeysSigsSelected = iItemsSelected;
	lpScratchCentralDir1 = lpScratchCentralDir;

	// Perform the desired operation on the selected keys.
	//....................................................
	while(iKeysSigsSelected != 0)
	{
		while(TRUE)
		{
			if (lpScratchCentralDir1->STATE)
			{
				break;
			}
			__asm
			{
				mov		eax,dwCDLength
				add		lpScratchCentralDir1,eax
			}
		}
		// Make sure it gets unmarked in case we have to select
		// again from the same central directory.
		//.....................................................
		lpScratchCentralDir1->STATE = 0;

		// We have a marked key or signature.
		//...................................
		CopyMemory(&CDLine,lpScratchCentralDir1,dwCDLength);

		// Read the index file to get the key/signature location
		// and length.
		//......................................................
		dwIdxOffset1 = CDLine.IDX_OFFS;
		dwBytesRead = ReadIndex1();
		if (dwBytesRead == -1)
		{
			goto EditError;
		}
		dwBytesRead = ReadRecord1();
		if (dwBytesRead == -1)
		{
			goto EditError;
		}
		// Clear out some variables that are common to most procedures.
		//.............................................................
		ZeroMemory(&TempUserId,sizeof(TempUserId));
		ZeroMemory(&TempSigId,sizeof(TempSigId));
		ZeroMemory(&TempOwnerId,sizeof(TempOwnerId));
		ZeroMemory(&UserId,sizeof(UserId));

		// Call the proper edit function from the table.
		//..............................................
		__asm
		{
			mov		eax,dwEditFunction
			call	EditFunctions[eax*4]
			mov		bResult,eax
		}
		// Clear any pass phrase we may have entered.
		//...........................................
		ZeroMemory(&szPassPhrase1,sizeof(szPassPhrase1));
		ZeroMemory(&szPassPhrase2,sizeof(szPassPhrase2));

		// If we cancelled or had an error, quit.
		//.......................................
		if (!bResult)
		{
			goto EditError;
		}
		// Setup the next entry to look at.
		//.................................
		__asm
		{
			mov		eax,dwCDLength
			add		lpScratchCentralDir1,eax
		}
		iKeysSigsSelected--;
	}
	// Lets clean up after ourselves.
	//...............................
	EditError:
	if (lpKeyBuffer1)
	{
		ZeroMemory(lpKeyBuffer1,SIZE_KEY_BUFF);
		DeallocateMemory(lpKeyBuffer1);
		lpKeyBuffer1 = 0;
	}
	if (lpKeyBuffer2)
	{
		ZeroMemory(lpKeyBuffer2,SIZE_KEY_BUFF);
		DeallocateMemory(lpKeyBuffer2);
		lpKeyBuffer2 = 0;
	}
	if (lpKeyBuffer3)
	{
		ZeroMemory(lpKeyBuffer3,SIZE_KEY_BUFF);
		DeallocateMemory(lpKeyBuffer3);
		lpKeyBuffer3 = 0;
	}
	if (lpSecretKeyCentralDir)
	{
		ZeroMemory(lpSecretKeyCentralDir,(dwSecretIds * sizeof(CD_STRUCT)));
		DeallocateMemory(lpSecretKeyCentralDir);
		lpSecretKeyCentralDir = 0;
	}
	if (lpPublicKeyCentralDir)
	{
		ZeroMemory(lpPublicKeyCentralDir,
				  ((dwPublicIds + dwPublicSigs - dwCompromiseSigs) * sizeof(CD_STRUCT)));
		DeallocateMemory(lpPublicKeyCentralDir);
		lpPublicKeyCentralDir = 0;
	}
	// Wipe out any evidence we may have from using the keys.
	//.......................................................
	ClearAllVariables();

	// Change back to the old help number.
	//....................................
	ChangeHelpTopic(dwOldHelpNumber);

	// Perform post processing checks, etc.
	//.....................................
	if (bWeChangedIt)
	{
		if (TypeKey == PUBLIC_KEY)
		{
			MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_CCPUBLICKEY,
						   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
		}
		else
		{
			MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_CCSECRETKEY,
						   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
		}
	}
	// Reindex and check the key rings if required.
	//.............................................
	if (dwSecretDeleted || dwPublicDeleted || bMaterialAdded)
	{
		bResult = IndexKeyRingFiles(hMainWindow);
		if (!bResult)
		{
			goto EditEnd;
		}
		dwSecretDeleted = 0;
		dwPublicDeleted = 0;
		bMaterialAdded = FALSE;
		bDoBackup = TRUE;

		// Check out the key rings.
		//.........................
		bResult = CheckOutTheKeyRings(TRUE,hMainWindow);
		if (!bResult)
		{
			goto EditEnd;
		}
	}
	else if (bKeysEdited)
	{
		// Check out the key rings.
		//.........................
		bResult = CheckOutTheKeyRings(TRUE,hMainWindow);
		if (!bResult)
		{
			goto EditEnd;
		}
		bKeysEdited = FALSE;
		bDoBackup = TRUE;
	}
	if (bDoBackup)
	{
		BackupFiles(AFTER_CHECK);
	}
	// The edit process is finished.
	//..............................
	EditEnd:
	bCancelOperation = FALSE;
	bProcessInProgress = FALSE;
}

// Build a central directory of keys and/or signatures to display
// for selecting for editing. Use the User ID index file to keep the
// keys in proper order in the display.
//..................................................................
BOOL BuildCentralDirectory(LPCD_STRUCT lpCentralDirectory, BOOL bEdit)
{
	LARGE_INTEGER	li;
	SYSTEMTIME		stTimestamp;
	BYTE			MyKeyId[8];
	LARGE_INTEGER	liMyTimestamp;
	LARGE_INTEGER	liSigTimestamp;
	DWORD			dwMyBits;
	DWORD			dwSigBits;
	int				iCompareResult;
	LPBYTE			lpNextPacket;
	LPBYTE			lpUserId;
	LPU_IDX_FMT		lpOurIndexBuffer;
	LPCD_STRUCT		lpCDScratch;
	DWORD			dwBytesRead;
	DWORD			dwCtb_Byte;
	DWORD			dwUserIdLength;
	DWORD			dwCDStructLength;
	BOOL			bKeyDisabled;
	BYTE			MyKeyType;
	BYTE			TempByte;
	BOOL			bResult = FALSE;
	BOOL			bSha;

	lpCDScratch = lpCentralDirectory;
	dwCDStructLength = sizeof(CD_STRUCT);

	// Pointer to index buffer which contain the user id.
	//...................................................
	lpOurIndexBuffer = lpIdxBuffer1;

	// Build the central directory.
	//.............................
	while(TRUE)
	{
		ZeroMemory(&CDLine,sizeof(CDLine));

		// Save the User ID index file offset.
		//....................................
		CDLine.IDX_OFFS = dwIdxOffset1;
		dwBytesRead = ReadIndex1();
		if (dwBytesRead == -1)
		{
			goto BuildEnd;
		}
		// Check for end of file.
		//.......................
		if (dwBytesRead == 0)
		{
			break;
		}
		// Read the key into memory.
		//..........................
		dwBytesRead = ReadRecord1();
		if (dwBytesRead == -1)
		{
			goto BuildEnd;
		}
		// Copy the user id from the index buffer to CDLine.
		// Each user id in a key will haved its own entry in
		// the index file.
		//..................................................
		CopyMemory(&CDLine.ID,lpOurIndexBuffer->USER_ID,sizeof(CDLine.ID));

		// Search for the key elements we want in our central
		// directory for this user id.
		//...................................................
		lpKeyBufferDup1 = lpKeyBuffer1;

		// Process the main key packet. Store the variables that
		// will be the same for all the User Ids for this key.
		//......................................................
		__asm
		{
			mov		edi,lpKeyBufferDup1
			mov		al,byte ptr [edi]
			mov		cl,al
			mov		dwCtb_Byte,ecx
			and		al,CTB_MASK
			mov		TempByte,al
		}
		// We can only have public or secret key packets as the
		// the first packet.
		//.....................................................
		if (TempByte == CTB_SECRET_KEY)
		{
			MyKeyType = SECRET_KEY;
		}
		else
		{
			MyKeyType = PUBLIC_KEY;
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		// Get the timestamp.
		//...................
		liMyTimestamp.QuadPart = 0;
		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			mov		lpNextPacket,edi
			add		lpNextPacket,eax
			add		edi,VERSION_SIZE
			mov		eax,dword ptr [edi]
			bswap	eax
			mov		liMyTimestamp.LowPart,eax

			// Get the high order 7 bits of the timestamp.
			//............................................
			mov		eax,dword ptr [edi+6]
			and		eax,0x00ff
			shr		eax,1
			mov		liMyTimestamp.HighPart,eax

			// Get the bits in Modulus n and the key id.
			//..........................................
			add		edi,(TIMESTAMP_SIZE + VALIDITY_SIZE + ALGORITHM_SIZE)
			movzx	eax,word ptr [edi]
			xchg	ah,al
			mov		dwMyBits,eax
			add		eax,7
			shr		eax,3
			add		edi,MPI_PREFIX_SIZE
			add		edi,eax
			sub		edi,KEY_ID_SIZE
			mov		eax,dword ptr [edi]
			mov		edx,dword ptr [edi+4]
			mov		dword ptr MyKeyId,eax
			mov		dword ptr MyKeyId[4],edx

			// Get the owner trust packet and see if the key
			// is disabled. 
			//..............................................
			mov		bKeyDisabled,FALSE
			cmp		MyKeyType,PUBLIC_KEY
			jne		L1
			mov		edi,lpNextPacket
			test	byte ptr [edi+2],DISABLED_BIT
			jz		L1
			mov		bKeyDisabled,TRUE
		  L1:
		}
		// Fill in the rest of the CDLine structure and put
		// it in the central directory. Put the key id into
		// the structure.
		//...................................
		CopyMemory(CDLine.KEY_SIG_ID,MyKeyId,KEY_ID_SIZE);

		ChangeToHex(SHORT_KEY_ID,(LPBYTE)&CDLine.KEY_SIG_ID[4],
				   (LPBYTE)&CDLine.KEY_SIG_ID_C,FORWARD);

		// Change the timestamp to a date and put it into the
		// structure.
		//...................................................
		TimestampToDateTime(liMyTimestamp.QuadPart,&stTimestamp);
		GetDateFormat(LOCALE_USER_DEFAULT,0,&stTimestamp,"ddd',' dd MMM yyyy",CDLine.DATE,18);

		// Put the key type in the structure.
		//...................................
		if (MyKeyType == PUBLIC_KEY)
		{
			CopyMemory(CDLine.KEY_TYPE,PubKey,lstrlen(PubKey));
			CDLine.TYPE_KEY = PUBLIC_KEY;
			CDLine.iImageIdx = 1;			// Red Key
		}
		else
		{
			CopyMemory(CDLine.KEY_TYPE,SecKey,lstrlen(SecKey));
			CDLine.TYPE_KEY = SECRET_KEY;
			CDLine.iImageIdx = 0;			// Blue Key
		}
		// If this is the universal key make it a gold key which is red.
		//..............................................................
		iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&cfg.V1.V2,KEY_ID_SIZE,
									  (LPCTSTR)&CDLine.KEY_SIG_ID,KEY_ID_SIZE);
		if (iCompareResult == CSTR_EQUAL)
		{
			CDLine.iImageIdx = 2;		// Gold Key
		}
		// If this is the Chat Key mark it.
		//.................................
		iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&cfg.cp.ChatKey,
									   KEY_ID_SIZE,(LPCTSTR)&CDLine.KEY_SIG_ID,KEY_ID_SIZE);
		if (iCompareResult == CSTR_EQUAL)
		{
			CDLine.iImageIdx = 5;
		}
		// Put in the number of bits.
		//...........................
		CDLine.NUMBER_OF_BITS = dwMyBits;
		FormatMyNumber(dwMyBits,(LPTSTR)&CDLine.BITS,sizeof(CDLine.BITS));

		// If the key is disabled, mark it with a yes else with a no.
		//...........................................................
		if (bKeyDisabled)
		{
			CopyMemory(CDLine.DISABLED,szYes,lstrlen(szYes));
		}
		else
		{
			CopyMemory(CDLine.DISABLED,szNo,lstrlen(szNo));
		}
		// Lets try and see if this key is PGP compatable. Secret Keys are automatically.
		//...............................................................................
		CDLine.bPGPCompatible = TRUE;
		if (MyKeyType == PUBLIC_KEY)
		{
			// We have to check all the signature packets for Md5, Sha1, or Sha512
			// sig types. To be PGP compatable all signatures must be Md5.
			//....................................................................
			lpKeyBufferDup1 = lpNextPacket;

			while(TRUE)
			{
				__asm
				{
					mov		edi,lpKeyBufferDup1
					mov		al,byte ptr [edi]
					mov		cl,al
					mov		dwCtb_Byte,ecx
					and		al,CTB_MASK
					mov		TempByte,al
				}
				// Check for end of the key.
				//..........................
				if (TempByte == 0)
				{
					break;
				}
				// If this is not a signature, set up for the next packet.
				//........................................................
				if (TempByte != CTB_SKE_PACKET)
				{
					GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

					__asm
					{
						mov		edi,lpKeyBufferDup1
						add		edi,CTB_SIZE
						add		edi,edx
						add		edi,eax
						mov		lpKeyBufferDup1,edi
					}
					continue;
				}
				else
				{
					bSha = FALSE;

					// We have a signature packet.
					//............................
					GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

					__asm
					{
						mov		edi,lpKeyBufferDup1
						add		edi,CTB_SIZE
						add		edi,edx
						cmp		byte ptr [edi+16],SHA_ALGORITHM
						je		A1
						cmp		byte ptr [edi+16],SHA512_ALGORITHM
						jne		L2
					A1: mov		bSha,1
						jmp		L3
					L2:	movzx	ecx,word ptr [edi+19]
						xchg	ch,cl
						cmp		ecx,4096
						jbe		L3
						mov		bSha,1
					L3:	add		edi,eax
						mov		lpKeyBufferDup1,edi
					}
					if (bSha)
					{
						CDLine.bPGPCompatible = FALSE;
						break;
					}
				}
			}
		}
		// Transfer the CDLine to the central directory.
		//..............................................
		CopyMemory(lpCDScratch,&CDLine,sizeof(CDLine));

		// Next entry in the central directory.
		//.....................................
		__asm
		{
			mov		eax,dwCDStructLength
			add		lpCDScratch,eax
		}
		// We only fill in information about signatures when we
		// are editing the public key ring. We have to search for
		// the user id and we only process signatures for this one
		// user id. First packet after key packet in lpNextPacket.
		//........................................................
		if (MyKeyType == PUBLIC_KEY && bEdit)
		{
			lpKeyBufferDup1 = lpNextPacket;
			while(TRUE)
			{
				__asm
				{
					mov		edi,lpKeyBufferDup1
					mov		al,byte ptr [edi]
					mov		cl,al
					mov		dwCtb_Byte,ecx
					and		al,CTB_MASK
					mov		TempByte,al
				}
				if (TempByte != CTB_USER_ID)
				{
					GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

					__asm
					{
						mov		edi,lpKeyBufferDup1
						add		edi,CTB_SIZE
						add		edi,edx
						add		edi,eax
						mov		lpKeyBufferDup1,edi
					}
				}
				else
				{
					GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

					__asm
					{
						mov		edi,lpKeyBufferDup1
						add		edi,CTB_SIZE
						add		edi,edx
						mov		lpUserId,edi
						mov		dwUserIdLength,eax
						add		edi,eax
						mov		lpKeyBufferDup1,edi
					}
					iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&CDLine.ID,
												   -1,lpUserId,dwUserIdLength);
					if (iCompareResult == CSTR_EQUAL)
					{
						break;
					}
				}
			}	// while(TRUE)

			// We have our user id. lpKeyBufferDup1 points to trust
			// packet after user id. Only make entries for the 
			// signatures on this user id.
			//.....................................................
			while(TRUE)
			{
				__asm
				{
					mov		edi,lpKeyBufferDup1
					mov		al,byte ptr [edi]
					mov		cl,al
					mov		dwCtb_Byte,ecx
					and		al,CTB_MASK
					mov		TempByte,al
				}
				// Check for next packet a user id, or end of key.
				//................................................
				if (TempByte == CTB_USER_ID || TempByte == 0)
				{
					break;
				}
				// If not a signature packet, set up for the next
				// packet.
				//...............................................
				if (TempByte != CTB_SKE_PACKET)
				{
					GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

					__asm
					{
						mov		edi,lpKeyBufferDup1
						add		edi,CTB_SIZE
						add		edi,edx
						add		edi,eax
						mov		lpNextPacket,edi
					}
				}
				else
				{
					// We have a signature packet.
					//............................
					GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

					__asm
					{
						mov		edi,lpKeyBufferDup1
						add		edi,CTB_SIZE
						add		edi,edx
						mov		lpNextPacket,edi
						add		lpNextPacket,eax
						add		edi,(VERSION_SIZE+1)
						mov		lpKeyBufferDup1,edi
						mov		al,byte ptr [edi]
						mov		TempByte,al
					}
					if (TempByte == KEY_COMPROMISE)
					{
						lpKeyBufferDup1 = lpNextPacket;
						continue;
					}
					// Get the sigs timestamp.
					//........................
					liSigTimestamp.QuadPart = 0;
					__asm
					{
						mov		edi,lpKeyBufferDup1
						inc		edi
						mov		eax,dword ptr [edi]
						bswap	eax
						mov		liSigTimestamp.LowPart,eax
		
						// Get the high order 7 bits of the timestamp.
						//............................................
						mov		eax,dword ptr [edi+12]
						and		eax,0x00ff
						shr		eax,1
						mov		liSigTimestamp.HighPart,eax

						add		edi,TIMESTAMP_SIZE
						mov		lpKeyBufferDup1,edi
					}
					TimestampToDateTime(liSigTimestamp.QuadPart,&stTimestamp);
					GetDateFormat(LOCALE_USER_DEFAULT,0,&stTimestamp,
								 "ddd',' dd MMM yyyy",CDLine.DATE,18);

					// Get the key id of the signature.
					//.................................
					__asm
					{
						mov		edi,lpKeyBufferDup1
						mov		eax,dword ptr [edi]
						mov		edx,dword ptr [edi+4]
						mov		dword ptr KeySID,eax
						mov		dword ptr KeySID[4],edx
						add		edi,(KEY_ID_SIZE+4)
						movzx	eax,word ptr [edi]
						xchg	ah,al
						mov		dwSigBits,eax
					}
					// Put the sig id into the structure.
					//...................................
					CopyMemory(CDLine.KEY_SIG_ID,&KeySID,KEY_ID_SIZE);
					ChangeToHex(SHORT_KEY_ID,(LPBYTE)&CDLine.KEY_SIG_ID[4],
							   (LPBYTE)&CDLine.KEY_SIG_ID_C,FORWARD);

					// Our type is a signature.
					//.........................
					ZeroMemory(CDLine.KEY_TYPE,sizeof(CDLine.KEY_TYPE));
					CopyMemory(CDLine.KEY_TYPE,Signature,lstrlen(Signature));
					CDLine.TYPE_KEY = SIG_PACKET;
					CDLine.iImageIdx = 3;

					// If this signature was created with the universal key
					// make it bright red.
					//.....................................................
					iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,
												  (LPCTSTR)&cfg.V1.V2,KEY_ID_SIZE,
												  (LPCTSTR)&CDLine.KEY_SIG_ID,KEY_ID_SIZE);
					if (iCompareResult == CSTR_EQUAL)
					{
						CDLine.iImageIdx = 4;
					}
					// Put in the number of bits.
					//...........................
					CDLine.NUMBER_OF_BITS = dwSigBits;
					ZeroMemory(CDLine.BITS,sizeof(CDLine.BITS));
					FormatMyNumber(dwSigBits,(LPTSTR)&CDLine.BITS,sizeof(CDLine.BITS));

					// The signature is not disabled at this point.
					//.............................................
					ZeroMemory(CDLine.DISABLED,sizeof(CDLine.DISABLED));
					CopyMemory(CDLine.DISABLED,szNo,lstrlen(szNo));

					// Clear the user id field.
					//.........................
					ZeroMemory(CDLine.ID,sizeof(CDLine.ID));

					// Search for a key for this signature so we can
					// get a user id for it.
					//..............................................
					li.QuadPart = SearchMyFileBinary(lpIndexFile2,&KeySID,KEY_ID_SIZE,
													 hIdxHandle2,0,&KeyIdSearch);
					if (li.QuadPart == -1)
					{
						goto BuildEnd;
					}
					// If we did not have a match put unknown in user
					// id for this signature.
					//...............................................
					if (li.QuadPart == 0)
					{
						CopyMemory(CDLine.ID,szUnknownSig,lstrlen(szUnknownSig));
					}
					else
					{
						// We had a match. Read the key and extract
						// the first user id and owner trust packet
						// to see if the key is disabled.
						//.........................................
						dwIdxOffset2 = li.HighPart;
						dwBytesRead = ReadIndex2();
						if (dwBytesRead == -1)
						{
							goto BuildEnd;
						}
						dwBytesRead = ReadRecord2();
						if (dwBytesRead == -1)
						{
							goto BuildEnd;
						}
						// The signature's key is now in lpKeyBuffer2.
						// Get the first user id.
						//............................................
						lpKeyBufferDup2 = lpKeyBuffer2;
						while(TRUE)
						{
							__asm
							{
								mov		edi,lpKeyBufferDup2
								mov		al,byte ptr [edi]
								mov		cl,al
								mov		dwCtb_Byte,ecx
								and		al,CTB_MASK
								mov		TempByte,al
							}
							if (TempByte == CTB_USER_ID)
							{
								GetPcktLength(lpKeyBufferDup2,dwCtb_Byte);

								__asm
								{
									mov		edi,lpKeyBufferDup2
									add		edi,CTB_SIZE
									add		edi,edx
									mov		lpUserId,edi
									mov		dwUserIdLength,eax
									add		edi,eax
									mov		lpKeyBufferDup2,edi
								}
								CopyMemory(CDLine.ID,lpUserId,dwUserIdLength);
								break;
							}
							else if (TempByte == CTB_TRUST)
							{
								GetPcktLength(lpKeyBufferDup2,dwCtb_Byte);

								__asm
								{
									mov		edi,lpKeyBufferDup2
									add		edi,CTB_SIZE
									add		edi,edx
									mov		bl,byte ptr [edi]
									mov		TempByte,bl
									add		edi,eax
									mov		lpKeyBufferDup2,edi
								}
								if (TempByte & DISABLED_BIT)
								{
									CopyMemory(CDLine.DISABLED,szYes,lstrlen(szYes));
								}
							}
							else
							{
								GetPcktLength(lpKeyBufferDup2,dwCtb_Byte);

								__asm
								{
									mov		edi,lpKeyBufferDup2
									add		edi,CTB_SIZE
									add		edi,edx
									add		edi,eax
									mov		lpKeyBufferDup2,edi
								}
							}
						}	// while(TRUE)
					}
					// Transfer this sig to the central directory.
					//............................................
					CopyMemory(lpCDScratch,&CDLine,sizeof(CDLine));
					__asm
					{
						mov		eax,dwCDStructLength
						add		lpCDScratch,eax
					}
				}
				// Get the next packet in the key.
				//................................
				lpKeyBufferDup1 = lpNextPacket;

			}	// while(TRUE) for signatures.
		}	// if (TypeKey == PUBLIC_KEY && bEsit)
		
		// Read the next index file record.
		//.................................
		dwIdxOffset1 += dwIdxSize1;

	}	// while(TRUE) for the key ring.

	bResult = TRUE;
	BuildEnd:

	return(bResult);
}

// Mark the keys we want to perform an operation on or with.
// Returns FALSE for an error.
//..........................................................
BOOL MarkTheKeys()
{
	RECT			rect;
	BOOL			bResult = FALSE;

	// Create our event for the edit virtual list window
	// so we do not return until we have made all of our
	// selections.
	//..................................................
	hEditEvent = CreateEvent(NULL,TRUE,FALSE,TEXT("EditEvent"));
	if (!hEditEvent)
	{
		ErrorProcedure(TEXT("EditEvent"),IDS_CREATEEVENT,MB_OK);
		goto MarkError;
	}
	// Setup the parent for the virtual list window so we can select 
	// keys and/or signatures to edit.
	//..............................................................
	GetClientRect(hMainWindow,&rect);

	hEditWindow = CreateWindowEx(0,lpszEditKeyRings,lpszNullString,
								 WS_CAPTION | WS_CHILD | WS_SYSMENU | 
								 WS_VISIBLE | WS_CLIPCHILDREN,rect.left,rect.top+37,
								 rect.right,rect.bottom-59,hMainWindow,NULL,hInst,NULL);

	if (!hEditWindow)
	{
		ErrorProcedure(lpszNA,IDS_CREATEWINEX,MB_OK);
		goto MarkError;
	}
	// Open the event object.
	//.......................
	hEditOpen = OpenEvent(SYNCHRONIZE,FALSE,TEXT("EditEvent"));
	if (!hEditOpen)
	{
		DestroyWindow(hEditWindow);
		goto MarkError;
	}
	// Only display the tip if we have not stopped it.
	//................................................
	if (cfg.dwTips & KEY_TIP)
	{
		dwTip = KEY_TIP;
		dwTipString = IDS_KEY_TIP;
		PostMessage(hEditWindow,WM_TIP,0,0);
	}
	// We have to wait for the Edit Event to become signaled before
	// we can return and process the selections from the Central
	// Directory.
	//.............................................................
	while(TRUE)
	{
		if (WaitForSingleObject(hEditEvent,0) == WAIT_OBJECT_0)
		{
			break;
		}
		EmptyTheMessageQue();
	}

	bResult = TRUE;

	MarkError:

	if (hEditOpen)
	{
		CloseHandle(hEditOpen);
		hEditOpen = 0;
	}
	if (hEditEvent)
	{
		CloseHandle(hEditEvent);
		hEditEvent = 0;
	}
	return(bResult);
}

// Create a new diary.
//....................
BOOL NewDiary()
{
	ULARGE_INTEGER		uliFreeCallerBytes;
	ULARGE_INTEGER		uliTotalBytes;
	ULARGE_INTEGER		uliFreeBytes;
	BOOL				bResult;
	int					iDlgResult;
	DWORD				dwBytesWritten;
	DWORD				dwSize;
	BOOL				bCreatedDiary = FALSE;
	HANDLE				hDiary = 0;
	OPENFILENAME		ofn;
	UINT				uiDriveType;
	HANDLE				hSearch;
	WIN32_FIND_DATA		wfd;
	BOOL				bSignedInOK;

	bJustCreated = FALSE;

	// Setup the headers.
	//...................
	ZeroMemory(&DiaryEnd,sizeof(DIARYEND));
	ZeroMemory(&DiaryHdr,sizeof(DIARYHDR));
	ZeroMemory(&szMyDiary,sizeof(szMyDiary));

	// Save the key id to the DIARYEND structure.
	//...........................................
	CopyMemory(&DiaryEnd.PkeHdr.KEY_ID,&CDLine.KEY_SIG_ID,KEY_ID_SIZE);

	CopyMemory(&DiaryHdr.id,&szDiaryId,4);
	CopyMemory(&DiaryEnd.id,&szDiaryId,4);

	// Let's get the diary name and password.
	//.......................................
	iDlgResult = DialogBox(hInst,TEXT("CREATEDIARY"),hMainWindow,(DLGPROC)CreateDiaryProc);

	// See if we had a system error in creating the dialog box.
	//.........................................................
	if (iDlgResult == -1)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto OpenEnd;
	}
	if (iDlgResult == IDCANCEL)
	{
		goto OpenEnd;
	}
	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_DIARYFILES);

	// Get the name to save the diary as.
	//...................................
	ofn.lpstrFile = szMyDiary;
	ofn.nMaxFile = MAX_PATH;
	ofn.hwndOwner = hMainWindow;
	ofn.lpstrFilter = TEXT("Top Secret Journal Files [.jrl]\0*.jrl\0All Files [*.*]\0*.*\0");
	ofn.nFilterIndex = 1;
	ofn.lpstrTitle = TEXT("Save Top Secret Journal As");
	ofn.Flags = (OFN_EXPLORER | OFN_PATHMUSTEXIST |OFN_NONETWORKBUTTON | 
				 OFN_ENABLEHOOK | OFN_ENABLESIZING |OFN_SHOWHELP | OFN_HIDEREADONLY);
	ofn.lpstrDefExt = TEXT("jrl");
	ofn.lpfnHook = MyOFNHookProc;

	// Setup the icon to use in the caption bar.
	//..........................................
	lpIconPointer = lpszAppName;

	while(TRUE)
	{
		ZeroMemory(&szMyDiary,MAX_PATH);

		// Get the name and path we want to use for our public key ring.
		//..............................................................
		if (!GetSaveFileName(&ofn))
		{
			CommDlgBoxErrorProc(IDS_SAVE_AS);
			goto OpenEnd;
		}
		SaveDirName((LPBYTE)&szMyDiary,SAVE_DIARYFILES | SAVE_SOURCE,TRUE);

		// Determine how much memory we have on the disk drive. Has to be 1 meg
		// or better.
		//.....................................................................
		ZeroMemory(&szRoot,sizeof(szRoot));
		CopyMemory(&szRoot,&szMyDiary,3);
		
		bResult = GetDiskFreeSpaceEx((LPCTSTR)&szRoot,
									(PULARGE_INTEGER)&uliFreeCallerBytes.QuadPart,
									(PULARGE_INTEGER)&uliTotalBytes.QuadPart,
									(PULARGE_INTEGER)&uliFreeBytes);
		if (!bResult)
		{
			ErrorProcedure((LPTSTR)&szMyDiary,IDS_GETFREEDSKSPACE,MB_OK);
			goto OpenEnd;
		}
		if (uliFreeCallerBytes.QuadPart == 0)
		{
			SetLastError(IDS_INSUFFICIENTSPACE);
			ErrorProcedure((LPTSTR)&szMyDiary,IDS_GETFREEDSKSPACE,MB_OK);
			continue;
		}
		// Make sure we have a valid drive type.
		//......................................
		uiDriveType = GetDriveType((LPCTSTR)&szRoot);

		// We do not want to store the files on a ram disk.
		//.................................................
		if (uiDriveType == DRIVE_RAMDISK)
		{
			SetLastError(IDS_RAMDRIVE);
			ErrorProcedure((LPTSTR)&szMyDiary,IDS_GETDRIVETYPE,MB_OK);
			continue;
		}
		// Make sure the file does not already exist.
		//...........................................
		hSearch = FindFirstFile((LPCTSTR)&szMyDiary,&wfd);

		if (hSearch == INVALID_HANDLE_VALUE)
		{
			break;
		}
		EmptyTheMessageQue();

		// The file exists, warn the user so he can enter another
		// file name.
		//.......................................................
		FindClose(hSearch);
		SetLastError(IDS_ALREADYEXISTS);
		ErrorProcedure((LPTSTR)&szMyDiary,IDS_FINDFIRSTFILE,MB_OK);
	}
	// Open the diary and write the initial data to disk.
	//...................................................
	hDiary = CreateMyFile((LPTSTR)&szMyDiary,GENERIC_READ | GENERIC_WRITE,
						   0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hDiary)
	{
		goto OpenEnd;
	}
	bResult = WriteMyFile((LPTSTR)&szMyDiary,hDiary,&DiaryHdr,sizeof(DiaryHdr),
						   &dwBytesWritten,NULL);
	if (!bResult)
	{
		goto OpenEnd;
	}
	// Fill out the DIARYEND header.
	//..............................
	DiaryEnd.PkeHdr.CTB = (CTB_PKE_PACKET | LENGTH_2);
	DiaryEnd.PkeHdr.VERSION = VERSION_NEW;
	DiaryEnd.PkeHdr.RSA_ALGOR = RSA_ALGORITHM;

	// Get the name of the computer. Diary can only be run on this machine.
	//.....................................................................
	dwSize = sizeof(DiaryEnd.szName);
	bResult = GetComputerName((LPTSTR)&DiaryEnd.szName,&dwSize);
	
	// If we are creating the diary under an admin account get a special code
	// from admin which will be required to change the computer the diary is
	// run on.
	//.......................................................................
	if (bAa)
	{
		DiaryEnd.bAdmin = TRUE;

		if (!bSignedIn)
		{
			// Sign in to your admin account.
			//...............................
			bSignedInOK = AdminSignIn(FALSE);
			bProcessInProgress = TRUE;

			if (!bSignedInOK)
			{
				goto OpenEnd;
			}
			// Get the special admin code required to change computers this
			// diary can run on.
			//.............................................................
			iDlgResult = DialogBox(hInst,TEXT("ADMINCODEDIARY"),hMainWindow,
								  (DLGPROC)AdminCodeDiaryProc);

			// See if we had a system error in creating the dialog box.
			//.........................................................
			if (iDlgResult == -1)
			{
				ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
				goto OpenEnd;
			}
			if (iDlgResult == IDCANCEL)
			{
				goto OpenEnd;
			}
		}
	}
	// Encrypt the DIARYEND header with the password.
	//...............................................
	GetRandomBits((CFB_LENGTH*8),&DiaryEnd.cfb);
	EncipherSecretComponents((LPBYTE)&szJrlPassWord,(LPBYTE)&DiaryEnd.id,
							  lstrlen((LPCTSTR)&szJrlPassWord),sizeof(DIARYEND)-CFB_LENGTH);

	bResult = WriteMyFile((LPTSTR)&szMyDiary,hDiary,&DiaryEnd,sizeof(DiaryEnd),
						   &dwBytesWritten,NULL);
	if (!bResult)
	{
		goto OpenEnd;
	}
	bResult = CloseMyHandle((LPTSTR)&szMyDiary,hDiary);
	if (!bResult)
	{
		goto OpenEnd;
	}
	hDiary = 0;
	bCreatedDiary = TRUE;
	bJustCreated = TRUE;

	OpenEnd:

	if (hDiary)
	{
		CloseMyHandle((LPTSTR)&szMyDiary,hDiary);
		if (!bCreatedDiary)
		{
			DeleteMyFile((LPTSTR)&szMyDiary);
		}
	}
	// If we created a diary post a command to open it.
	//.................................................
	if (bCreatedDiary)
	{
		bJustCreated = TRUE;
		lpMyCmdLine = (LPTSTR)&szMyDiary;
		bLogo = TRUE;
		PostMessage(hMainWindow,WM_COMMAND,IDM_OPEN_DIARY,0);
	}
	return(TRUE);
}

// CALLBACK procedure for getting the Admin Code to change where diary can be used.
//.................................................................................
LRESULT CALLBACK AdminCodeDiaryProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	DWORD		dwLengthPP1;
	DWORD		dwLengthPP2;
	int			iResult;
	LPCTSTR		lpDiaryName;
	BYTE		AllEqual;
	DWORD		dwV;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Set the text limits for the administrator name and pass phrases.
			//.................................................................
			SendDlgItemMessage(hDlg,IDC_ADMINCODEPP1,EM_SETLIMITTEXT,(WPARAM) 16,0);
			SendDlgItemMessage(hDlg,IDC_ADMINCODEPP2,EM_SETLIMITTEXT,(WPARAM) 16,0);
			ZeroMemory(&szPassWord1,sizeof(szPassWord1));
			ZeroMemory(&szPassWord2,sizeof(szPassWord2));
			ZeroMemory(&szTemp1,sizeof(szTemp1));
			ZeroMemory(&szTemp2,sizeof(szTemp2));

			lpDiaryName = PathFindFileName((LPCTSTR)&szMyDiary);
			SetDlgItemText(hDlg,IDC_DIARY,lpDiaryName);

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDC_ADMINCODEPP1));
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDOK:
				{
					// Now check out the admin codes.
					//.............................
					GetDlgItemText(hDlg,IDC_ADMINCODEPP1,(LPTSTR)&szTemp1,sizeof(szTemp1));
					GetDlgItemText(hDlg,IDC_ADMINCODEPP2,(LPTSTR)&szTemp2,sizeof(szTemp2));

					dwLengthPP1 = lstrlen((LPCTSTR)&szTemp1);
					dwLengthPP2 = lstrlen((LPCTSTR)&szTemp2);

					// If the underlying password is all character 191s, get the
					// real password from its real location.
					//...........................................................
					__asm
					{
						mov		al,DEFAULT_CHAR
						mov		ecx,dwLengthPP1
						mov		edi,offset szTemp1
						repe	scasb
						sete	AllEqual
					}
					if (!AllEqual)
					{
						// Combine the two different fields.
						//..................................
						for (dwV = 0; dwV < dwLengthPP1; dwV++)
						{
							if ((BYTE)szTemp1[dwV] != DEFAULT_CHAR)
							{
								szPassWord1[dwV] = szTemp1[dwV];
							}
						}
					}
					// If the underlying password is all character 191s, get the
					// real password from its real location.
					//...........................................................
					__asm
					{
						mov		al,DEFAULT_CHAR
						mov		ecx,dwLengthPP2
						mov		edi,offset szTemp2
						repe	scasb
						sete	AllEqual
					}
					if (!AllEqual)
					{
						// Combine the two different fields.
						//..................................
						for (dwV = 0; dwV < dwLengthPP2; dwV++)
						{
							if ((BYTE)szTemp2[dwV] != DEFAULT_CHAR)
							{
								szPassWord2[dwV] = szTemp2[dwV];
							}
						}
					}
					iResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szPassWord1,-1,
										   (LPCTSTR)&szPassWord2,-1);
					if (iResult != CSTR_EQUAL ||
					   (iResult == CSTR_EQUAL && (dwLengthPP1 == 0 || dwLengthPP1 > 16)))
					{
						MessageBoxProc(hDlg,IDS_ADVISORY,IDS_ADMINCODENOTEQ,
									   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
						SetDlgItemText(hDlg,IDC_ADMINCODEPP1,lpszNullString);
						SetDlgItemText(hDlg,IDC_ADMINCODEPP2,lpszNullString);
						ZeroMemory(&szTemp1,sizeof(szTemp1));
						ZeroMemory(&szTemp2,sizeof(szTemp2));
						ZeroMemory(&szPassWord1,sizeof(szPassWord1));
						ZeroMemory(&szPassWord2,sizeof(szPassWord2));
						break;
					}
					CopyMemory(&DiaryEnd.szCode,&szPassWord1,dwLengthPP1);
					ZeroMemory(&szTemp1,sizeof(szTemp1));
					ZeroMemory(&szTemp2,sizeof(szTemp2));
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDC_PPTSCGTEXT:
				{
					VirtualKeyboard(hDlg,IDC_ADMINCODEPP1,(LPBYTE)&szPassWord1,
									sizeof(szPassWord1));
					SetFocus(GetDlgItem(hDlg,IDC_ADMINCODEPP1));
				}
				break;

				case IDC_PPTEXT2:
				{
					VirtualKeyboard(hDlg,IDC_ADMINCODEPP2,(LPBYTE)&szPassWord2,
									sizeof(szPassWord2));
					SetFocus(GetDlgItem(hDlg,IDC_ADMINCODEPP2));
				}
				break;

				case IDCANCEL:
				{
					SetDlgItemText(hDlg,IDC_ADMINCODEPP1,lpszNullString);
					SetDlgItemText(hDlg,IDC_ADMINCODEPP2,lpszNullString);
					ZeroMemory(&szPassWord1,sizeof(szPassWord1));
					ZeroMemory(&szPassWord2,sizeof(szPassWord2));
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_ADMINCODECLEAR:
				{
					SetDlgItemText(hDlg,IDC_ADMINCODEPP1,lpszNullString);
					SetDlgItemText(hDlg,IDC_ADMINCODEPP2,lpszNullString);
					ZeroMemory(&szPassWord1,sizeof(szPassWord1));
					ZeroMemory(&szPassWord2,sizeof(szPassWord2));
					SetFocus(GetDlgItem(hDlg,IDC_DIARYNAME));
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// CALLBACK procedure for create a New Diary dialog box.
//......................................................
LRESULT CALLBACK CreateDiaryProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	DWORD		dwLengthPP1;
	DWORD		dwLengthPP2;
	DWORD		dwOwnerLength;
	int			iResult;
	BYTE		AllEqual;
	DWORD		dwV;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Set the text limits for the administrator name and pass phrases.
			//.................................................................
			SendDlgItemMessage(hDlg,IDC_DIARYNAME,EM_SETLIMITTEXT,(WPARAM) 48,0);
			SendDlgItemMessage(hDlg,IDC_DIARYPP1,EM_SETLIMITTEXT,(WPARAM) 255,0);
			SendDlgItemMessage(hDlg,IDC_PP2,EM_SETLIMITTEXT,(WPARAM) 255,0);
			ZeroMemory(&szPassWord1,sizeof(szPassWord1));
			ZeroMemory(&szPassWord2,sizeof(szPassWord2));
			ZeroMemory(&szTemp1,sizeof(szTemp1));
			ZeroMemory(&szTemp2,sizeof(szTemp2));

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDC_DIARYNAME));
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDOK:
				{
					// Check out the values and make sure they are OK.
					//................................................
					GetDlgItemText(hDlg,IDC_DIARYNAME,(LPTSTR)&DiaryEnd.Owner,
								   sizeof(DiaryEnd.Owner));
					dwOwnerLength = lstrlen((LPCTSTR)&DiaryEnd.Owner);
					if (dwOwnerLength == 0 || dwOwnerLength > 48)
					{
						MessageBoxProc(hDlg,IDS_ADVISORY,IDS_NODIARYNAME,
									   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
						SetFocus(GetDlgItem(hDlg,IDC_DIARYNAME));
						ZeroMemory(&DiaryEnd.Owner,sizeof(DiaryEnd.Owner));
						break;
					}
					// Now check out the passwords.
					//.............................
					GetDlgItemText(hDlg,IDC_DIARYPP1,(LPTSTR)&szTemp1,MAX_PATH);
					GetDlgItemText(hDlg,IDC_PP2,(LPTSTR)&szTemp2,MAX_PATH);

					dwLengthPP1 = lstrlen((LPCTSTR)&szTemp1);
					dwLengthPP2 = lstrlen((LPCTSTR)&szTemp2);

					// If the underlying password is all character 191s, get the
					// real password from its real location.
					//...........................................................
					__asm
					{
						mov		al,DEFAULT_CHAR
						mov		ecx,dwLengthPP1
						mov		edi,offset szTemp1
						repe	scasb
						sete	AllEqual
					}
					if (!AllEqual)
					{
						// Combine the two different fields.
						//..................................
						for (dwV = 0; dwV < dwLengthPP1; dwV++)
						{
							if ((BYTE)szTemp1[dwV] != DEFAULT_CHAR)
							{
								szPassWord1[dwV] = szTemp1[dwV];
							}
						}
					}
					// If the underlying password is all character 191s, get the
					// real password from its real location.
					//...........................................................
					__asm
					{
						mov		al,DEFAULT_CHAR
						mov		ecx,dwLengthPP2
						mov		edi,offset szTemp2
						repe	scasb
						sete	AllEqual
					}
					if (!AllEqual)
					{
						// Combine the two different fields.
						//..................................
						for (dwV = 0; dwV < dwLengthPP2; dwV++)
						{
							if ((BYTE)szTemp2[dwV] != DEFAULT_CHAR)
							{
								szPassWord2[dwV] = szTemp2[dwV];
							}
						}
					}

					iResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szPassWord1,-1,
										   (LPCTSTR)&szPassWord2,-1);
					if (iResult != CSTR_EQUAL ||
					   (iResult == CSTR_EQUAL && (dwLengthPP1 < 6 || dwLengthPP1 > 255)))
					{
						MessageBoxProc(hDlg,IDS_ADVISORY,IDS_DIARYPPNOTEQ,
									   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
						SetDlgItemText(hDlg,IDC_DIARYPP1,lpszNullString);
						SetDlgItemText(hDlg,IDC_PP2,lpszNullString);
						ZeroMemory(&szPassWord1,sizeof(szPassWord1));
						ZeroMemory(&szPassWord2,sizeof(szPassWord2));
						ZeroMemory(&szTemp1,sizeof(szTemp1));
						ZeroMemory(&szTemp2,sizeof(szTemp2));
						SetFocus(GetDlgItem(hDlg,IDC_DIARYPP1));
						break;
					}
					CopyMemory(&szJrlPassWord,&szPassWord1,sizeof(&szPassWord1));
					ZeroMemory(&szTemp,sizeof(szTemp));
					ZeroMemory(&szTemp1,sizeof(szTemp1));
					ZeroMemory(&szTemp2,sizeof(szTemp2));
					ZeroMemory(&szPassWord1,sizeof(szPassWord1));
					ZeroMemory(&szPassWord2,sizeof(szPassWord2));
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDC_PPTEXT1:
				{
					VirtualKeyboard(hDlg,IDC_DIARYPP1,(LPBYTE)&szPassWord1,
									sizeof(szPassWord1));
					SetFocus(GetDlgItem(hDlg,IDC_DIARYPP1));
				}
				break;

				case IDC_PPTEXT2:
				{
					VirtualKeyboard(hDlg,IDC_PP2,(LPBYTE)&szPassWord2,
									sizeof(szPassWord2));
					SetFocus(GetDlgItem(hDlg,IDC_PP2));
				}
				break;

				case IDCANCEL:
				{
					ClearDiaryEntries(hDlg);
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_DIARYCLEAR:
				{
					ClearDiaryEntries(hDlg);
					SetFocus(GetDlgItem(hDlg,IDC_DIARYNAME));
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Clear the diary entries.
//.........................
VOID ClearDiaryEntries(HWND hDlg)
{
	SetDlgItemText(hDlg,IDC_DIARYNAME,lpszNullString);
	SetDlgItemText(hDlg,IDC_DIARYPP1,lpszNullString);
	SetDlgItemText(hDlg,IDC_PP2,lpszNullString);
	ZeroMemory(&szJrlPassWord,sizeof(szJrlPassWord));
	ZeroMemory(&DiaryEnd.Owner,sizeof(DiaryEnd.Owner));
	ZeroMemory(&szPassWord1,sizeof(szPassWord1));
	ZeroMemory(&szPassWord2,sizeof(szPassWord2));
}

// View fingerprint and other information about a public key.
// Return FALSE for cancel or error.
//...........................................................
BOOL ViewKeyFingerprint()
{
	BOOL		bResult = TRUE;
	int			iDlgResult;

	iDlgResult = DialogBox(hInst,TEXT("KEYFINGERPRINT"),hMainWindow,
						  (DLGPROC)KeyFingerprintProc);
	if (iDlgResult == IDCANCEL)
	{
		bResult = FALSE;
	}
	EmptyTheMessageQue();

	return(bResult);
}

// CALLBACK procedure for displaying key fingerprint information.
//...............................................................
LRESULT CALLBACK KeyFingerprintProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			UINT			ui = 74;

			// Set the tabstops in the edit controls.
			//.......................................
			SendDlgItemMessage(hDlg,IDC_MD5_FP,EM_SETTABSTOPS,1,(LPARAM)&ui);
			SendDlgItemMessage(hDlg,IDC_SHA_FP,EM_SETTABSTOPS,1,(LPARAM)&ui);

			// Retrieve some of the fingerprint material.
			//...........................................
			GetFingerprint(hDlg);

			// Set the key id.
			//................
			SetDlgItemText(hDlg,IDC_FKEY_ID,(LPCTSTR)&CDLine.KEY_SIG_ID_C);

			// Set the size in bits of the key.
			//.................................
			SetDlgItemText(hDlg,IDC_FKEY_SIZE,(LPCTSTR)&CDLine.BITS);

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			SetWindowText(hDlg,(LPCTSTR)&CDLine.ID);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));

			SetFocus(GetDlgItem(hDlg,IDOK));

			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDOK:
				{
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDCANCEL:
				{
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Set the Chat key.
//..................
BOOL SetTheChatKey()
{
	// Just copy the key id.
	//......................
	CopyMemory(&cfg.cp.ChatKey,&CDLine.KEY_SIG_ID,KEY_ID_SIZE);
	bChatKeySet = TRUE;

	return(TRUE);
}

// Set the universal public key to use.
//.....................................
BOOL SetUniversalKey()
{
	// If we got here, get the key id and move it
	// to our admin account information. it Must
	// be greater than or equal to 2,200 bits.
	//...........................................
	if (CDLine.NUMBER_OF_BITS >= 2200)
	{
		CopyMemory(&cfg.V1.V2,&CDLine.KEY_SIG_ID,sizeof(cfg.V1.V2));
		bUniversalSet = TRUE;
	}
	else
	{
		MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_UKEYTOOSMALL,
					   MB_ICONSTOP | MB_OK | MB_HELP,MB_ICONSTOP,0);
		bUniversalSet = FALSE;
	}
	return(TRUE);
}

// Export a Public Key to the clipboard.
//......................................
BOOL ExportPublicKey()
{
	BOOL			bResult;
	int				iCompareResult;

	// If this is the universal key only allow the administrator to export it.
	//........................................................................
	if (bAa && bRestrictionsInEffect)
	{
		iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&cfg.V1.V2,KEY_ID_SIZE,
									  (LPCTSTR)&CDLine.KEY_SIG_ID,KEY_ID_SIZE);
		if (iCompareResult == CSTR_EQUAL)
		{
			CheckEditError(IDS_EDITPUBLICKEY,(LPBYTE)&CDLine.ID,NULL,
						   IDS_ONLYADMINEXTR,IDS_ADMIN_SKIPPED,
						   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
			return(TRUE);
		}
	}

	bResult = PublicKeyToClipboard(lpKeyBuffer1);

	return(bResult);
}

// Add a user id to a secret and public key.
// Returns FALSE for error or cancel.
//..........................................
BOOL AddUserId()
{
	LARGE_INTEGER	li;
	BOOL			bResult = TRUE;
	int				iResult;
	BOOL			bSignTheKey;
	DWORD			dwCtb_Byte;
	int				iDlgResult;
	int				iCompareResult;
	DWORD			dwBytesWritten;
	DWORD			dwBytesRead;
	TCHAR			szNewMessage[64];
	BYTE			TempCTB;

	bSignTheKey = TRUE;

	// If this is the universal key only allow the administrator to add a new
	// user id.
	//.......................................................................
	if (bAa && bRestrictionsInEffect)
	{
		iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&cfg.V1.V2,KEY_ID_SIZE,
									  (LPCTSTR)&CDLine.KEY_SIG_ID,KEY_ID_SIZE);
		if (iCompareResult == CSTR_EQUAL)
		{
			CheckEditError(IDS_EDITSECRETKEY,(LPBYTE)&CDLine.ID,NULL,
						   IDS_ONLYADMINNEWID,IDS_ADMIN_SKIPPED,
					       MB_ICONHAND | MB_OK,MB_ICONHAND,0);

			goto AddUserEnd;
		}
	}
	// We cannot modify the same key twice in the same pass.
	//......................................................
	lpKeyBufferDup1 = lpKeyBuffer1;

	__asm
	{
		mov		edi,lpKeyBufferDup1
		mov		cl,byte ptr [edi]
		mov		TempCTB,cl
	}
	if (TempCTB & DELETED_BIT)
	{
		CheckEditError(IDS_EDITSECRETKEY,(LPBYTE)&CDLine.ID,NULL,
					   IDS_NOMODIFYTWICE,IDS_ADDNEWIDSKIPPED,
					   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
		goto AddUserEnd;
	}
	// Get the user id to be appended to the public and secret keys.
	//..............................................................
	iDlgResult = DialogBox(hInst,TEXT("ADDNEWUSERID"),hMainWindow,(DLGPROC)AddNewUserIdProc);

	// See if we had a system error in creating the 
	// dialog box.
	//.............................................
	if (iDlgResult == -1)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		bResult = FALSE;
		goto AddUserEnd;
	}

	if (iDlgResult == IDCANCEL || iLengthOfUserId == 0)
	{
		goto AddUserEnd;
	}
	// We have a good new user id. Append it to the secret key first.
	//...............................................................
	CopyMemory(lpKeyBuffer2,lpKeyBuffer1,SIZE_KEY_BUFF);

	__asm
	{
		mov		eax,dwRecordLength1
		mov		dwRecordLength2,eax
		mov		edi,lpKeyBuffer2
		add		edi,eax
		mov		al,CTB_USER_ID
		or		al,LENGTH_1
		stosb
		inc		dwRecordLength2
		mov		eax,iLengthOfUserId
		stosb
		inc		dwRecordLength2
		add		dwRecordLength2,eax
		mov		ecx,eax
		mov		esi,offset szUserID
		rep		movsb
	}
	li.QuadPart = 0;
	li.QuadPart = SetMyFilePointer((LPTSTR)&cfg.szSecretKeyRing,hSecretKeyRing,li.QuadPart,
								    FILE_END);
	if (li.QuadPart == -1)
	{
		bResult = FALSE;
		goto AddUserEnd;
	}
	bResult = WriteMyFile((LPTSTR)&cfg.szSecretKeyRing,hSecretKeyRing,
						   lpKeyBuffer2,dwRecordLength2,&dwBytesWritten,NULL);
	if (!bResult)
	{
		goto AddUserEnd;
	}
	// Mark the original key for deletion.
	//....................................
	bResult = MarkKey1(DELETE_IT);
	if (!bResult)
	{
		goto AddUserEnd;
	}
	// Setup to sign the new user id for the public key.
	//..................................................
	CopyMemory(&TempUserId,&CDLine.ID,sizeof(CDLine.ID));
	iResult = SignSetup(lpKeyBuffer1,IDS_NOADDNEWUSER,IDS_INVALIDNEWIDPP);
	if (iResult == -1)
	{
		bResult = FALSE;
		goto AddUserEnd;
	}
	// If secret components not decrypted, just add the user id
	// to the public key.
	//.........................................................
	if (iResult == 0)
	{
		bSignTheKey = FALSE;
	}
	// We have to find the public key to add the new user id to.
	//..........................................................
	CopyMemory(&KeySID,&CDLine.KEY_SIG_ID,KEY_ID_SIZE);

	li.QuadPart = SearchMyFileBinary((LPBYTE)&szPublicRingKeyId,&KeySID,
									  KEY_ID_SIZE,hPublicRingKeyId,0,&KeyIdSearch);
	if (li.QuadPart == -1)
	{
		bResult = FALSE;
		goto AddUserEnd;
	}
	// We did not have a match. Say so and continue with the
	// next key.
	//......................................................
	if (li.QuadPart == 0)
	{
		// No matching public key to add a new user id to.
		//................................................
		CheckEditError(IDS_EDITSECRETKEY,(LPBYTE)&CDLine.ID,NULL,
					   IDS_MATCHPUBKEYNOTFOUND,IDS_NOADDNEWIDTOPUBKEY,
					   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
		goto AddUserEnd;
	}
	// We had a match. Temporarily setup group two for 
	// public key with key id index.
	//................................................
	SetUpGroup(PUBLIC_KEY,INDEX_KEY,GROUP_TWO);

	dwIdxOffset2 = li.HighPart;
	dwBytesRead = ReadIndex2();
	if (dwBytesRead == -1)
	{
		bResult = FALSE;
		goto AddUserEnd;
	}
	dwBytesRead = ReadRecord2();
	if (dwBytesRead == -1)
	{
		bResult = FALSE;
		goto AddUserEnd;
	}
	// Reset group two to public key with user id index.
	//..................................................
	SetUpGroup(PUBLIC_KEY,INDEX_UID,GROUP_TWO);

	CopyMemory(lpKeyBuffer1,lpKeyBuffer2,SIZE_KEY_BUFF);
	CopyMemory(&CDLine1,&CDLine,sizeof(CDLine));

	// Setup dwPublicComp with the size of the public key packet.
	// Contrary to documentation include the CTB byte and length
	// field.
	//..........................................................
	lpKeyBufferDup1 = lpKeyBuffer1;

	__asm
	{
		mov		edi,lpKeyBufferDup1
		mov		cl,byte ptr [edi]
		mov		dwCtb_Byte,ecx
	}
	GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

	__asm
	{
		add		eax,edx
		add		eax,CTB_SIZE
		mov		dwPublicComp,eax
	
		// Append the user id to the end of the public key in 
		// lpKeyBuffer2.
		//...................................................
		mov		eax,dwRecordLength2
		mov		dwRecordLength1,eax
		mov		edi,lpKeyBuffer2
		add		edi,eax
		mov		al,CTB_USER_ID
		or		al,LENGTH_1
		stosb
		inc		dwRecordLength1
		mov		eax,iLengthOfUserId
		stosb
		inc		dwRecordLength1
		add		dwRecordLength1,eax
		mov		ecx,eax
		mov		esi,offset szUserID
		rep		movsb

		// Add a trust packet. Since it is our own key we mark
		// it as complete trust.
		//....................................................
		mov		al,CTB_TRUST
		or		al,LENGTH_1
		stosb
		inc		dwRecordLength1
		mov		al,1
		stosb
		inc		dwRecordLength1
		mov		al,UID_COMPL_TRUST
		stosb
		inc		dwRecordLength1
	}
	li.QuadPart = 0;
	li.QuadPart = SetMyFilePointer((LPTSTR)&cfg.szPublicKeyRing,hPublicKeyRing,li.QuadPart,
								    FILE_END);
	if (li.QuadPart == -1)
	{
		bResult = FALSE;
		goto AddUserEnd;
	}
	bResult = WriteMyFile((LPTSTR)&cfg.szPublicKeyRing,hPublicKeyRing,
						   lpKeyBuffer2,dwRecordLength1,&dwBytesWritten,NULL);
	if (!bResult)
	{
		goto AddUserEnd;
	}
	// Mark the original key for deletion and write it to disk.
	// Swap some ops for the MarkKey1 function.
	//.........................................................
	SwapOps((LPBYTE)&hKeyHandle1,(LPBYTE)&hKeyHandle2,4);
	SwapOps((LPBYTE)&lpRingFile1,(LPBYTE)&lpRingFile2,4);
	SwapOps((LPBYTE)&dwRecordLength1,(LPBYTE)&dwRecordLength2,4);
	SwapOps((LPBYTE)&dwRingFileOffset1,(LPBYTE)&dwRingFileOffset2,4);

	TypeKey = PUBLIC_KEY;
	bResult = MarkKey1(DELETE_IT);

	// Swap the ops back.
	//...................
	SwapOps((LPBYTE)&hKeyHandle1,(LPBYTE)&hKeyHandle2,4);
	SwapOps((LPBYTE)&lpRingFile1,(LPBYTE)&lpRingFile2,4);
	SwapOps((LPBYTE)&dwRecordLength1,(LPBYTE)&dwRecordLength2,4);
	SwapOps((LPBYTE)&dwRingFileOffset1,(LPBYTE)&dwRingFileOffset2,4);

	bWeChangedIt = TRUE;

	// We have to set lpKeyBuffer1 back to what it should be for
	// signing.
	//..........................................................
	CopyMemory(lpKeyBuffer1,lpKeyBuffer2,dwPublicComp);

	// Now sign the key if we have a decrypted secret key.
	//....................................................
	if (bSignTheKey)
	{	
		// Setup the skip counters for the CheckForMessages function.
		//...........................................................
		__asm
		{
			mov		iSkipCounter,250
			mov		iInitialSkipValue,250
		}
		// We are go for creating the signature.
		//......................................
		bCancelOperation = FALSE;
		uiCalcsMessage = IDS_NEWUSERIDCALCS;
		hDialogModeLess = CreateDialog(hInst,TEXT("SIGNATURECALCULATIONS"),
									   hMainWindow,(DLGPROC)SignatureCalcsProc);
		if (!hDialogModeLess)
		{
			ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
			bResult = FALSE;
			goto AddUserEnd;
		}
		// Create the signature for the new user id, which is returned 
		// in lpKeyBuffer2.
		//............................................................
		SignMyKey(KEY_CERT_SELF);

		EmptyTheMessageQue();

		if (bCancelOperation)
		{
			bResult = TRUE;
			goto AddUserEnd;
		}
		// Change the cancel button to OK.
		//................................
		SetDlgItemText(hDialogModeLess,IDCANCEL,TEXT("&OK"));
		NotifyMe();
		
		// Append the signature to the end of the new user id.
		//....................................................
		li.QuadPart = 0;
		li.QuadPart = SetMyFilePointer((LPTSTR)&cfg.szPublicKeyRing,hPublicKeyRing,
									    li.QuadPart,FILE_END);
		if (li.QuadPart == -1)
		{
			goto AddUserEnd;
		}
		bResult = WriteMyFile((LPTSTR)&cfg.szPublicKeyRing,hPublicKeyRing,lpKeyBuffer2,
							   dwSignatureSize,&dwBytesWritten,NULL);
		if (!bResult)
		{
			goto AddUserEnd;
		}
		// Change the message text to signature calcs completed.
		//......................................................
		LoadString(hInst,IDS_SIGCOMPLETED,(LPTSTR)&szNewMessage,sizeof(szNewMessage));
		SetDlgItemText(hDialogModeLess,IDC_MYMESSAGE,(LPCTSTR)&szNewMessage);

		// Wait for the dialog box to be closed.
		//......................................
		while(TRUE)
		{
			CheckForMessages();

			if (bCancelOperation == TRUE)
			{
				break;
			}
		}
	}
	AddUserEnd:
	bCancelOperation = FALSE;
	TypeKey = SECRET_KEY;

	ClearAllVariables();

	if (hDialogModeLess)
	{
		DestroyWindow(hDialogModeLess);
	}
	return(bResult);
}

// Dialog box procedure for getting a new user id to add
// to a public and secret key pair.
//......................................................
LRESULT CALLBACK AddNewUserIdProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	int			iMBResult;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			ZeroMemory(&szUserID,sizeof(szUserID));
			iLengthOfUserId = 0;

			// Set the user id.
			//..................
			SetDlgItemTextFmt(hDlg,IDC_OLDUSERID,(LPCTSTR)&CDLine.ID);

			// Set the text limit for the new user id.
			//........................................
			SendDlgItemMessage(hDlg,IDC_NEWUSERID,EM_SETLIMITTEXT,(WPARAM) 250,0);

			// Center the window.
			//...................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDOK:
				{
					// Retrieve the new user id.
					//..........................
					GetDlgItemText(hDlg,IDC_NEWUSERID,(LPTSTR)&szUserID,sizeof(szUserID)-1);
					iLengthOfUserId = lstrlen((LPCTSTR)&szUserID);

					// We did not enter a user id.
					//............................
					if (iLengthOfUserId == 0)
					{
						iMBResult = MessageBoxProc(hDlg,IDS_INPUT_ERROR,IDS_NONEWUSERID,
												   MB_ICONQUESTION | MB_YESNO,
												   MB_ICONQUESTION,0);
						if (iMBResult == IDNO)
						{
							SetFocus(GetDlgItem(hDlg,IDC_NEWUSERID));
							break;
						}
					}
					EndDialog(hDlg,IDOK);
				}
				break;
				
				case IDCANCEL:
				{
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_CLOSE:
		{
			// Retrieve the new user id.
			//..........................
			GetDlgItemText(hDlg,IDC_NEWUSERID,(LPTSTR)&szUserID,sizeof(szUserID)-1);
			iLengthOfUserId = lstrlen((LPCTSTR)&szUserID);

			// We did not enter a user id.
			//............................
			if (iLengthOfUserId == 0)
			{
				iMBResult = MessageBoxProc(hDlg,IDS_INPUT_ERROR,IDS_NONEWUSERID,
									       MB_ICONQUESTION | MB_YESNO,MB_ICONQUESTION,0);
				if (iMBResult == IDNO)
				{
					SetFocus(GetDlgItem(hDlg,IDC_NEWUSERID));
					break;
				}
			}
			EndDialog(hDlg,IDOK);
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;
	
		default:
			return(FALSE);
	}
	return(TRUE);
}

// Add, change, or delete a pass phrase on a secret key.
// Returns FALSE for error or cancel.
//......................................................
BOOL ChangePassPhrase()
{
	LARGE_INTEGER		li;
	BOOL				bResult;
	DWORD				dwAlgorithmPtr;
	LPBYTE				lpEncipherPtr;
	LPVOID				lpRandomBitsPtr;
	DWORD				dwSizeAlgorithm;
	DWORD				dwCtb_Byte;
	DWORD				dwKeyLength;
	DWORD				dwBytesWritten;
	DWORD				dwBytesToEncipher;
	DWORD				dwBytesToWrite;
	DWORD				dwCheckSum;
	int					iDlgResult;
	int					iCompareResult;
	BOOL				bAlreadyEnciphered;
	TCHAR				szStatement[256];
	TCHAR				szOutBuff[1024];

	bResult = TRUE;
	bAlreadyEnciphered = TRUE;

	// If this is the universal key only allow the administrator to add a new
	// user id.
	//.......................................................................
	if (bAa && bRestrictionsInEffect)
	{
		iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&cfg.V1.V2,KEY_ID_SIZE,
									  (LPCTSTR)&CDLine.KEY_SIG_ID,KEY_ID_SIZE);
		if (iCompareResult == CSTR_EQUAL)
		{
			CheckEditError(IDS_EDITSECRETKEY,(LPBYTE)&CDLine.ID,NULL,
						   IDS_ONLYADMINCHPP,IDS_ADMIN_SKIPPED,
						   MB_ICONHAND | MB_OK,MB_ICONHAND,0);

			goto ChangePPEnd;
		}
	}
	// We cannot modify the same key twice in one pass.
	//.................................................
	if (*lpKeyBuffer1 & DELETED_BIT)
	{
		CheckEditError(IDS_EDITSECRETKEY,(LPBYTE)&CDLine.ID,NULL,
					   IDS_NOMODIFYTWICE,IDS_CHANGEPPSKIPPED,
					   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
		goto ChangePPEnd;
	}
	// Setup the user id in TempUserId for the pass phrase 
	// dialog boxes.
	//....................................................
	CopyMemory(&TempUserId,&CDLine.ID,sizeof(CDLine.ID));

	// Check and see if the key is enciphered or not.
	//...............................................
	lpKeyBufferDup1 = lpKeyBuffer1;

	__asm
	{
		mov		edi,lpKeyBufferDup1
		mov		cl,byte ptr [edi]
		mov		dwCtb_Byte,ecx
	}
	GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

	__asm
	{
		push	eax
		add		eax,edx
		add		eax,CTB_SIZE
		mov		dwKeyLength,eax
		pop		eax
		mov		edi,lpKeyBufferDup1
		add		edi,CTB_SIZE
		add		edi,edx
		
		// Get to the algorithm byte for encryption.
		//..........................................
		add		edi,(VERSION_SIZE+TIMESTAMP_SIZE+VALIDITY_SIZE+ALGORITHM_SIZE)
		movzx	eax,word ptr [edi]
		xchg	ah,al

		// Determine the length of modulus n and exponent e to get
		// to the algorithm byte for the type of encryption that
		// protects the secret components.
		//........................................................
		add		edi,MPI_PREFIX_SIZE
		add		eax,7
		shr		eax,3
		add		edi,eax
		movzx	eax,word ptr [edi]
		xchg	ah,al
		add		edi,MPI_PREFIX_SIZE
		add		eax,7
		shr		eax,3
		add		edi,eax

		// Save algorithm position and size up to and including
		// algorithm byte.
		//.....................................................
		mov		ecx,lpKeyBuffer1
		mov		dwAlgorithmPtr,edi
		sub		dwAlgorithmPtr,ecx
		mov		dwSizeAlgorithm,edi
		sub		dwSizeAlgorithm,ecx
		inc		dwSizeAlgorithm
		mov		lpKeyBufferDup1,edi		// Points to algorithm byte.
	}
	// If the cipher algorithm byte equals 0, the secret components
	// are not encrypted.
	//.............................................................
	if (*lpKeyBufferDup1 == NO_ENCRYPTION)
	{
		bAlreadyEnciphered = FALSE;
	}
	// Handle the enciphered case first.
	//..................................
	if (bAlreadyEnciphered)
	{
		__asm
		{
			mov		edi,lpKeyBufferDup1
			inc		edi			// Past algorithm byte
			add		edi,CFB_LENGTH
			mov		lpEncipherPtr,edi

			// Determine the length of the enciphered components.
			//...................................................
			mov		eax,dwKeyLength
			mov		ecx,edi
			sub		ecx,lpKeyBuffer1
			sub		eax,ecx
			mov		dwBytesToEncipher,eax
		}
		// Get the current pass phrase to decipher the secret
		// components.
		//...................................................
		CopyMemory(lpKeyBuffer2,lpKeyBuffer1,SIZE_KEY_BUFF);
		uiGetPassPhraseMsg = IDS_NOCHANGEPP;

		while(TRUE)
		{
			iDlgResult = DialogBox(hInst,TEXT("GETCURRENTPASSPHRASE"),hMainWindow,
								  (DLGPROC)GetCurrentPassPhraseProc);

			// See if we had a system error in creating the dialog box.
			//.........................................................
			if (iDlgResult == -1)
			{
				ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
				goto ChangePPEnd;
			}
			// If we did not enter a pass phrase exit without changing
			// the current pass phrase.
			//........................................................
			if (iDlgResult == IDCANCEL)
			{
				goto ChangePPEnd;;
			}
			// We entered a pass phrase, see if it is the right one.
			//......................................................
			DecipherSecretComponents((LPBYTE)&szPassPhrase1,lpEncipherPtr,
									  iLengthOfPassPhrase,dwBytesToEncipher);

			// Do the checksum on the secret components.
			//..........................................
			dwCheckSum = CheckSum(lpEncipherPtr,(dwBytesToEncipher-2));

			__asm
			{
				mov		edi,lpEncipherPtr
				mov		ebx,dwBytesToEncipher
				sub		ebx,2
				movzx	eax,word ptr [edi][ebx]
				xchg	ah,al
				mov		edx,dwCheckSum
				cmp		eax,edx
				je		GetNewPassPhrase
			}
			// An invalid pass phrase was entered. Say so.
			//............................................
			CopyMemory(lpKeyBuffer1,lpKeyBuffer2,SIZE_KEY_BUFF);
			MessageBoxProc(hMainWindow,IDS_INPUT_ERROR,IDS_INVALIDCHNGPP,
						   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
		}	// while(TRUE)

	  GetNewPassPhrase:

		iDlgResult = DialogBox(hInst,TEXT("GETNEWPASSPHRASE"),hMainWindow,
							  (DLGPROC)GetNewPassPhraseProc);

		// See if we had a system error in creating the dialog box.
		//.........................................................
		if (iDlgResult == -1)
		{
			ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
			goto ChangePPEnd;
		}
		// If we cancelled exit without changing the secret key.
		//......................................................
		if (iDlgResult == IDCANCEL)
		{
			goto ChangePPEnd;
		}
		// No pass phrase entered write an unprotected secret
		// key to disk.
		//...................................................
		if (iLengthOfPassPhrase == 0)
		{
			CopyMemory(lpKeyBuffer2,lpKeyBuffer1,SIZE_KEY_BUFF);
			lpKeyBufferDup1 = lpKeyBuffer2;

			__asm
			{
				mov		edi,lpKeyBufferDup1
				mov		cl,byte ptr [edi]
				mov		dwCtb_Byte,ecx
			}
			GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup1
				add		edi,CTB_SIZE
				sub		eax,8
				cmp		edx,1
				jne		L1
				mov		byte ptr [edi],al
				jmp		L3
			L1:	cmp		edx,2
				jne		L2
				xchg	ah,al
				mov		word ptr [edi],ax
				jmp		L3
			L2:	bswap	eax
				mov		dword ptr [edi],eax

				// Set the algorithm byte to no encryption.
				//.........................................
			L3:	mov		edi,lpKeyBuffer2
				add		edi,dwAlgorithmPtr
				mov		byte ptr [edi],NO_ENCRYPTION
			}
			// Move the file pointer to the end of the file.
			// We will append the new secret key to the end
			// and mark the old one for deletion.
			//.............................................
			li.QuadPart = 0;
			li.QuadPart = SetMyFilePointer((LPTSTR)&cfg.szSecretKeyRing,
										    hSecretKeyRing,li.QuadPart,FILE_END);
			if (li.QuadPart == -1)
			{
				goto ChangePPEnd;
			}
			bResult = WriteMyFile((LPTSTR)&cfg.szSecretKeyRing,hSecretKeyRing,lpKeyBuffer2,
								   dwSizeAlgorithm,&dwBytesWritten,NULL);
			if (!bResult)
			{
				goto ChangePPEnd;
			}
			// Calculate the length of the rest of the secret key
			// to write to disk.
			//...................................................
			__asm
			{
				mov		eax,dwRecordLength1
				sub		eax,dwKeyLength
				add		eax,dwBytesToEncipher
				mov		dwBytesToWrite,eax
			}
			bResult = WriteMyFile((LPTSTR)&cfg.szSecretKeyRing,hSecretKeyRing,lpEncipherPtr,
								   dwBytesToWrite,&dwBytesWritten,NULL);
			if (!bResult)
			{
				goto ChangePPEnd;
			}
			bResult = MarkKey1(DELETE_IT);
			if (!bResult)
			{
				goto ChangePPEnd;
			}
			// Tell the user that the secret components are no longer
			// protected.
			//.......................................................
			LoadString(hInst,IDS_NOPPINEFFECT,szStatement,sizeof(szStatement));
			StringCbPrintf(szOutBuff,sizeof(szOutBuff),TEXT("User ID: %s \n\n%s"),
						   CDLine.ID,szStatement);
			MessageBoxProc(hMainWindow,IDS_ADVISORY,(UINT)szOutBuff,
						   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
		}
		else
		{
			// Reencipher the secret components with the new
			// phrase and new 64 bits of feedback data.
			//..............................................
			__asm
			{
				mov		edi,lpEncipherPtr
				sub		edi,8
				mov		lpRandomBitsPtr,edi
			}
			GetRandomBits((CFB_LENGTH*8),lpRandomBitsPtr);
			EncipherSecretComponents((LPBYTE)&szPassPhrase1,lpEncipherPtr,
								      iLengthOfPassPhrase,dwBytesToEncipher);

			// Write the whole record back to disk.
			//.....................................
			bResult = WriteRecord1();
			if (!bResult)
			{
				goto ChangePPEnd;
			}
			// Tell the user that the new pass phrase is in effect.
			//.....................................................
			LoadString(hInst,IDS_NEWPPINEFFECT,szStatement,sizeof(szStatement));
			StringCbPrintf(szOutBuff,sizeof(szOutBuff),TEXT("User ID: %s \n\n%s"),CDLine.ID,
						   szStatement);
			MessageBoxProc(hMainWindow,IDS_ADVISORY,(UINT)szOutBuff,
						   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
		}
	}
	else
	{
		// The secret components are not enciphered. Get a new
		// pass phrase to encipher them. lpKeyBuffer1 points
		// to the algorithm byte.
		//....................................................
		__asm
		{
			mov		edi,lpKeyBufferDup1
			inc		edi				// Past algorithm byte.
			mov		lpEncipherPtr,edi
			sub		edi,lpKeyBuffer1
			mov		eax,dwKeyLength
			sub		eax,edi
			mov		dwBytesToEncipher,eax
		}
		// Get a new pass phrase to protect the secret components with.
		//.............................................................
		iDlgResult = DialogBox(hInst,TEXT("GETNEWPASSPHRASE"),hMainWindow,
							  (DLGPROC)GetNewPassPhraseProc);

		// See if we had a system error in creating the dialog box.
		//.........................................................
		if (iDlgResult == -1)
		{
			ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
			goto ChangePPEnd;
		}
		// If we cancelled, or no pass phrase entered, exit without
		// changing the secret key.
		//.........................................................
		if (iDlgResult == IDCANCEL || iLengthOfPassPhrase == 0)
		{
			goto ChangePPEnd;
		}
		// Add 8 to the length field and change the algorithm byte
		// to TSC_ALGORITHM.
		//........................................................
		CopyMemory(lpKeyBuffer2,lpKeyBuffer1,SIZE_KEY_BUFF);
		lpKeyBufferDup1 = lpKeyBuffer2;

		__asm
		{
			mov		edi,lpKeyBufferDup1
			mov		cl,byte ptr [edi]
			mov		dwCtb_Byte,ecx
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		eax,8
			cmp		edx,1
			jne		L4
			mov		byte ptr [edi],al
			jmp		L6
		L4:	cmp		edx,2
			jne		L5
			xchg	ah,al
			mov		word ptr [edi],ax
			jmp		L6
		L5:	bswap	eax
			mov		dword ptr [edi],eax

			// Set the algorithm byte to TSC_ALGORITHM.
			//.........................................
		L6:	mov		edi,lpKeyBuffer2
			add		edi,dwAlgorithmPtr
			mov		byte ptr [edi],TSC_ALGORITHM
		}
		// Write the first section of the new secret key to disk
		// at the end of the secret key ring.
		//......................................................
		li.QuadPart = 0;
		li.QuadPart = SetMyFilePointer((LPTSTR)&cfg.szSecretKeyRing,
									    hSecretKeyRing,li.QuadPart,FILE_END);
		if (li.QuadPart == -1)
		{
			goto ChangePPEnd;
		}
		bResult = WriteMyFile((LPTSTR)&cfg.szSecretKeyRing,hSecretKeyRing,
							   lpKeyBuffer2,dwSizeAlgorithm,&dwBytesWritten,NULL);
		if (!bResult)
		{
			goto ChangePPEnd;
		}
		// We need to get our random 64 bits of feedback data
		// and place them in the 8 bytes preceeding the secret
		// components.
		//....................................................
		__asm
		{
			mov		edi,lpEncipherPtr
			sub		edi,8
			mov		lpRandomBitsPtr,edi
		}
		GetRandomBits(64,lpRandomBitsPtr);
		EncipherSecretComponents((LPBYTE)&szPassPhrase1,lpEncipherPtr,
								  iLengthOfPassPhrase,dwBytesToEncipher);

		// Determine the number of bytes to write to disk.
		//................................................
		__asm
		{
			mov		eax,dwRecordLength1
			sub		eax,dwKeyLength
			add		eax,8
			add		eax,dwBytesToEncipher
			mov		dwBytesToWrite,eax
		}
		// Write the remaining parts of the secret key to disk.
		//.....................................................
		bResult = WriteMyFile((LPTSTR)&cfg.szSecretKeyRing,hSecretKeyRing,
							   lpRandomBitsPtr,dwBytesToWrite,&dwBytesWritten,NULL);
		if (!bResult)
		{
			goto ChangePPEnd;
		}
		bResult = MarkKey1(DELETE_IT);
		if (!bResult)
		{
			goto ChangePPEnd;
		}
		// Tell the user his new pass phrase is in effect.
		//................................................
		LoadString(hInst,IDS_NEWPPINEFFECT,szStatement,sizeof(szStatement));
		StringCbPrintf(szOutBuff,sizeof(szOutBuff),TEXT("User ID: %s \n\n%s"),CDLine.ID,
					   szStatement);
		MessageBoxProc(hMainWindow,IDS_ADVISORY,(UINT)szOutBuff,
					   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
	}

	ChangePPEnd:
	return(bResult);
}

// CALLBACK procedure for the enter a new pass phrase dialog box.
//...............................................................
LRESULT CALLBACK GetNewPassPhraseProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	int			iCompareResult;
	DWORD		dwLengthPP2;
	BYTE		AllEqual;
	int			i;
	DWORD		dwV;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Set the text limit for the pass phrase.
			//........................................
			SendDlgItemMessage(hDlg,IDC_COPY1,EM_SETLIMITTEXT,(WPARAM) 250,0);
			SendDlgItemMessage(hDlg,IDC_COPY2,EM_SETLIMITTEXT,(WPARAM) 250,0);

			// Clear the pass phrase.
			//.......................
			ZeroMemory(&szPassPhrase1,sizeof(szPassPhrase1));
			ZeroMemory(&szPassPhrase2,sizeof(szPassPhrase2));
			iLengthOfPassPhrase = 0;
			ZeroMemory(&szTemp1,sizeof(szTemp1));
			ZeroMemory(&szTemp2,sizeof(szTemp2));

			// Set the current user id.
			//.........................
			SetDlgItemTextFmt(hDlg,IDC_CURRENTUID,(LPCTSTR)&TempUserId);

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDC_COPY1));
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDOK:
				{
					// Retrieve the pass phrase.
					//..........................
					GetDlgItemText(hDlg,IDC_COPY1,szTemp1,sizeof(szTemp1)-1);
					GetDlgItemText(hDlg,IDC_COPY2,szTemp2,sizeof(szTemp2)-1);

					// Check out the pass phrase.
					//...........................
					iLengthOfPassPhrase = lstrlen((LPTSTR)&szTemp1);
					dwLengthPP2 = lstrlen((LPTSTR)&szTemp2);

					// If the underlying password is all character 191s, get the
					// real password from its real location.
					//...........................................................
					__asm
					{
						mov		al,DEFAULT_CHAR
						mov		ecx,iLengthOfPassPhrase
						mov		edi,offset szTemp1
						repe	scasb
						sete	AllEqual
					}
					if (!AllEqual)
					{
						// Combine the two different fields.
						//..................................
						for (i = 0; i < iLengthOfPassPhrase; i++)
						{
							if ((BYTE)szTemp1[i] != DEFAULT_CHAR)
							{
								szPassPhrase1[i] = szTemp1[i];
							}
						}
					}
					// If the underlying password is all character 191s, get the
					// real password from its real location.
					//...........................................................
					__asm
					{
						mov		al,DEFAULT_CHAR
						mov		ecx,dwLengthPP2
						mov		edi,offset szTemp2
						repe	scasb
						sete	AllEqual
					}
					if (!AllEqual)
					{
						// Combine the two different fields.
						//..................................
						for (dwV = 0; dwV < dwLengthPP2; dwV++)
						{
							if ((BYTE)szTemp2[dwV] != DEFAULT_CHAR)
							{
								szPassPhrase2[dwV] = szTemp2[dwV];
							}
						}
					}
					iCompareResult = lstrcmp(szPassPhrase1,szPassPhrase2);

					if (iCompareResult != 0)
					{
						MessageBoxProc(hDlg,IDS_INPUT_ERROR,IDS_PPDIFF,
									   MB_ICONHAND | MB_OK,MB_ICONHAND,0);

						SetDlgItemText(hDlg,IDC_COPY1,lpszNullString);
						SetDlgItemText(hDlg,IDC_COPY2,lpszNullString);
						ZeroMemory(&szTemp1,sizeof(szTemp1));
						ZeroMemory(&szTemp2,sizeof(szTemp2));
						ZeroMemory(&szPassPhrase1,sizeof(szPassPhrase1));
						ZeroMemory(&szPassPhrase2,sizeof(szPassPhrase2));
						SetFocus(GetDlgItem(hDlg,IDC_COPY1));
						break;
					}
					// Inform the user that the secret components
					// will not be protected since he entered no
					// pass phrase.
					//...........................................
					if (iLengthOfPassPhrase == 0)
					{
						MessageBoxProc(hDlg,IDS_ADVISORY,IDS_NONEWPP,
									   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
					}
					SetDlgItemText(hDlg,IDC_COPY1,lpszNullString);
					SetDlgItemText(hDlg,IDC_COPY2,lpszNullString);
					ZeroMemory(&szTemp1,sizeof(szTemp1));
					ZeroMemory(&szTemp2,sizeof(szTemp2));
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDC_CLEARPP1:
				{
					SetDlgItemText(hDlg,IDC_COPY1,lpszNullString);
					SetDlgItemText(hDlg,IDC_COPY2,lpszNullString);
					ZeroMemory(&szPassPhrase1,sizeof(szPassPhrase1));
					ZeroMemory(&szPassPhrase2,sizeof(szPassPhrase2));
					SetFocus(GetDlgItem(hDlg,IDC_COPY1));
				}
				break;

				case IDC_COPY1TEXT:
				{
					VirtualKeyboard(hDlg,IDC_COPY1,(LPBYTE)&szPassPhrase1,
									sizeof(szPassPhrase1));
					SetFocus(GetDlgItem(hDlg,IDC_COPY1));
				}
				break;

				case IDC_COPY2TEXT:
				{
					VirtualKeyboard(hDlg,IDC_COPY2,(LPBYTE)&szPassPhrase2,
									sizeof(szPassPhrase2));
					SetFocus(GetDlgItem(hDlg,IDC_COPY2));
				}
				break;

				case IDCANCEL:
				{
					SetDlgItemText(hDlg,IDC_COPY1,lpszNullString);
					SetDlgItemText(hDlg,IDC_COPY2,lpszNullString);
					ZeroMemory(&szPassPhrase1,sizeof(szPassPhrase1));
					ZeroMemory(&szPassPhrase2,sizeof(szPassPhrase2));
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Delete a key from a public or secret key ring.
// Returns FALSE for error or cancel.
//...............................................
BOOL DeleteKeys()
{
	LPBYTE		lpOurId;
	DWORD		dwNumberOfUserIds;
	DWORD		dwCtb_Byte;
	UINT		uiTempTitle;
	UINT		uiTempQuestion;
	int			iCompareResult;
	int			iUserIdLength;
	int			iResult;
	BOOL		bThisIdOnly;
	BOOL		bOurOwnKey;
	BOOL		bResult;
	TCHAR		szTitle[24];
	TCHAR		szQuestion[140];
	TCHAR		szOutBuff[1024];
	BYTE		TempCTB;
	BYTE		TempByte;

	bOurOwnKey = FALSE;
	dwNumberOfUserIds = 0;
	bThisIdOnly = FALSE;

	// If this is the universal key only allow the administrator to delete it.
	//........................................................................
	if (bAa && bRestrictionsInEffect)
	{
		iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&cfg.V1.V2,KEY_ID_SIZE,
									  (LPCTSTR)&CDLine.KEY_SIG_ID,KEY_ID_SIZE);
		if (iCompareResult == CSTR_EQUAL)
		{
			if (TypeKey == PUBLIC_KEY)
			{
				uiTempTitle = IDS_EDITPUBLICKEY;
			}
			else
			{
				uiTempTitle = IDS_EDITSECRETKEY;
			}
			CheckEditError((UINT)uiTempTitle,(LPBYTE)&CDLine.ID,NULL,
							IDS_ONLYADMINDELETE,IDS_ADMIN_SKIPPED,
							MB_ICONHAND | MB_OK,MB_ICONHAND,0);

			bResult = TRUE;
			goto DelKeyEnd;
		}
	}
	// Get the offset into the key for the user id in case we only
	// want to delete this id and not the whole key.
	//............................................................
	lpKeyBufferDup1 = lpKeyBuffer1;

	while(TRUE)
	{
		__asm
		{
			mov		edi,lpKeyBufferDup1
			mov		al,byte ptr [edi]
			mov		cl,al
			mov		dwCtb_Byte,ecx
			and		al,CTB_MASK
			mov		TempCTB,al
		}
		if (TempCTB != CTB_USER_ID)
		{
			GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup1
				add		edi,CTB_SIZE
				add		edi,edx
				add		edi,eax
				mov		lpKeyBufferDup1,edi
			}
		}
		else
		{
			lpOurId = lpKeyBufferDup1;
			GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

			_asm
			{
				mov		edi,lpKeyBufferDup1
				add		edi,CTB_SIZE
				add		edi,edx
				mov		lpKeyBufferDup2,edi		// Id offset.
				add		edi,eax
				mov		iUserIdLength,eax
				mov		lpKeyBufferDup1,edi
			}
			iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,lpKeyBufferDup2,
										   iUserIdLength,CDLine.ID,-1);

			if (iCompareResult == CSTR_EQUAL)
			{
				break;
			}
		}
	}
	// Setup for the message box which asks if we really want to
	// delete this key
	//...........................................................
	if (TypeKey == PUBLIC_KEY)
	{
		uiTempTitle = IDS_EDITPUBLICKEY;
		uiTempQuestion = IDS_DELPUBQUESTION;
	}
	else
	{
		uiTempTitle = IDS_EDITSECRETKEY;
		uiTempQuestion = IDS_DELSECQUESTION;
	}
	LoadString(hInst,uiTempTitle,szTitle,sizeof(szTitle));
	LoadString(hInst,uiTempQuestion,szQuestion,sizeof(szQuestion));

	// Format all the output for the message box.
	//...........................................
	StringCbPrintf(szOutBuff,sizeof(szOutBuff),TEXT("User ID: %s \n\n%s"),CDLine.ID,
				   szQuestion);

	// Display the message box with the question.
	//...........................................
	iResult = MessageBoxProc(hMainWindow,(UINT)szTitle,(UINT)szOutBuff,
							 MB_YESNOCANCEL | MB_ICONQUESTION | MB_HELP,
							 MB_ICONQUESTION,0);
	if (iResult == IDCANCEL)
	{
		bResult = FALSE;
		goto DelKeyEnd;
	}
	else if (iResult == IDNO)
	{
		bResult = TRUE;
		goto DelKeyEnd;
	}
	// If this is a public key check to see if it is a buckstop key
	// where we can delete only one id if we want.
	//.............................................................
	lpKeyBufferDup1 = lpKeyBuffer1;

	if (TypeKey == PUBLIC_KEY)
	{
		__asm
		{
			mov		edi,lpKeyBufferDup1
			mov		cl,byte ptr [edi]
			mov		dwCtb_Byte,ecx
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			add		edi,eax
			mov		cl,byte ptr [edi]
			mov		dwCtb_Byte,ecx
			mov		lpKeyBufferDup1,edi
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			mov		al,byte ptr [edi]
			mov		TempByte,al
		}
		if (TempByte & BUCKSTOP_BIT)
		{
			bOurOwnKey = TRUE;
		}
	}
	if (TypeKey == SECRET_KEY)
	{
		bOurOwnKey = TRUE;
	}
	// See how many user ids we have if this is one our own keys.
	//...........................................................
	if (bOurOwnKey)
	{
		lpKeyBufferDup1 = lpKeyBuffer1;
		
		while(TRUE)
		{
			// Break if this is the end of the key.
			//.....................................
			if (*lpKeyBufferDup1 == 0)
			{
				break;
			}
			__asm
			{
				mov		edi,lpKeyBufferDup1
				mov		al,byte ptr [edi]
				mov		cl,al
				mov		dwCtb_Byte,ecx
				and		al,CTB_MASK
				mov		TempCTB,al
			}
			if (TempCTB != CTB_USER_ID)
			{
				GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

				__asm
				{
					mov		edi,lpKeyBufferDup1
					add		edi,CTB_SIZE
					add		edi,edx
					add		edi,eax
					mov		lpKeyBufferDup1,edi
				}
			}
			else
			{
				dwNumberOfUserIds++;
				GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

				__asm
				{
					mov		edi,lpKeyBufferDup1
					add		edi,CTB_SIZE
					add		edi,edx
					add		edi,eax
					mov		lpKeyBufferDup1,edi
				}
			}
		}
	}
	// If this is one of our own keys and we have more than one 
	// user id, see if we want to delete only this user id or the
	// whole key.
	//...........................................................
	if (bOurOwnKey && dwNumberOfUserIds > 1)
	{
		LoadString(hInst,IDS_DELONLYTHISID,szQuestion,sizeof(szQuestion));

		// Format the output for the message box.
		//.......................................
		StringCbPrintf(szOutBuff,sizeof(szOutBuff),TEXT("User ID: %s \n\n%s"),CDLine.ID,
					   szQuestion);

		// Display the message box with the question.
		//...........................................
		iResult = MessageBoxProc(hMainWindow,(UINT)szTitle,(UINT)szOutBuff,
								 MB_YESNOCANCEL | MB_ICONQUESTION | MB_HELP,
								 MB_ICONQUESTION,0);
		if (iResult == IDCANCEL)
		{
			bResult = FALSE;
			goto DelKeyEnd;
		}
		else if (iResult == IDNO)
		{
			bThisIdOnly = FALSE;
		}
		else
		{
			bThisIdOnly = TRUE;
		}
	}
	// If we have elected to only delete this id, do it.
	// We delete associated trust and signature packets
	// that belong to this user id.
	//.................................................
	if (bThisIdOnly)
	{
		__asm
		{
			mov		edi,lpOurId

			// Mark the user id for deletion and go to the 
			// following packets.
			//............................................
			or		byte ptr [edi],DELETED_BIT
			mov		cl,byte ptr [edi]
			mov		dwCtb_Byte,ecx
		}
		GetPcktLength(lpOurId,dwCtb_Byte);

		__asm
		{
			mov		edi,lpOurId
			add		edi,CTB_SIZE
			add		edi,edx
			add		edi,eax
			mov		lpOurId,edi
		}
		// Delete the following packets up to the end of the
		// key or the next user id.
		//..................................................
		while(TRUE)
		{
			if (*lpOurId == 0)
			{
				break;
			}
			__asm
			{
				mov		edi,lpOurId
				mov		al,byte ptr [edi]
				mov		cl,al
				mov		dwCtb_Byte,ecx
				and		al,CTB_MASK
				mov		TempCTB,al
			}
			if (TempCTB == CTB_USER_ID)
			{
				break;
			}
			// Mark the packet for deletion.
			//..............................
			__asm
			{
				mov		edi,lpOurId
				or		byte ptr [edi],DELETED_BIT
				mov		cl,byte ptr [edi]
				mov		dwCtb_Byte,ecx
			}
			GetPcktLength(lpOurId,dwCtb_Byte);

			__asm
			{
				mov		edi,lpOurId
				add		edi,CTB_SIZE
				add		edi,edx
				add		edi,eax
				mov		lpOurId,edi
			}
		}
		bResult = WriteRecord1();
		if (!bResult)
		{
			goto DelKeyEnd;
		}
		if (TypeKey == PUBLIC_KEY)
		{
			dwPublicDeleted++;
		}
		else
		{
			dwSecretDeleted++;
		}
		bWeChangedIt = TRUE;
	}
	else
	{
		// Delete the whole key.
		//......................
		bResult = MarkKey1(DELETE_IT);
		if (!bResult)
		{
			goto DelKeyEnd;
		}
		bWeChangedIt = TRUE;
	}

	DelKeyEnd:
	return(bResult);
}

// Extract keys from a secret or public key ring.
// Returns FALSE for error or cancel.
//...............................................
BOOL ExtractKeys()
{
	OPENFILENAME	ofn;
	LPBYTE			lpTrustPacket;
	BOOL			bResult;
	int				iResult;
	int				iCompareResult;
	DWORD			dwCtb_Byte;
	DWORD			dwBytesWritten;
	UINT			uiTempTitle;
	UINT			uiTempQuestion;
	TCHAR			szTitle[24];
	TCHAR			szQuestion[64];
	TCHAR			szOutBuff[1024];
	HANDLE			hKeyFile;
	HANDLE			hSearch;
	WIN32_FIND_DATA	wfd;
	BYTE			PreviousPacket;
	BYTE			HoldPacket;
	BYTE			TempCTB;

	PreviousPacket = 0;

	// If this is the universal key only allow the administrator to extract it.
	//.........................................................................
	if (bAa && bRestrictionsInEffect)
	{
		iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&cfg.V1.V2,KEY_ID_SIZE,
									  (LPCTSTR)&CDLine.KEY_SIG_ID,KEY_ID_SIZE);
		if (iCompareResult == CSTR_EQUAL)
		{
			if (TypeKey == PUBLIC_KEY)
			{
				uiTempTitle = IDS_EDITPUBLICKEY;
			}
			else
			{
				uiTempTitle = IDS_EDITSECRETKEY;
			}
			CheckEditError((UINT)uiTempTitle,(LPBYTE)&CDLine.ID,NULL,
							IDS_ONLYADMINEXTR,IDS_ADMIN_SKIPPED,
							MB_ICONHAND | MB_OK,MB_ICONHAND,0);

			bResult = TRUE;
			goto ExtractEnd;
		}
	}
	// Setup the message box which asks if we really want to
	// extract this key.
	//......................................................
	if (TypeKey == PUBLIC_KEY)
	{
		uiTempTitle = IDS_EDITPUBLICKEY;
		uiTempQuestion = IDS_EXTRACTPUBLIC;
	}
	else
	{
		uiTempTitle = IDS_EDITSECRETKEY;
		uiTempQuestion = IDS_EXTRACTSECRET;
	}
	LoadString(hInst,uiTempTitle,szTitle,sizeof(szTitle));
	LoadString(hInst,uiTempQuestion,szQuestion,sizeof(szQuestion));

	// Format all the output for the message box.
	//...........................................
	StringCbPrintf(szOutBuff,sizeof(szOutBuff),TEXT("User ID: %s \n\n%s"),CDLine.ID,
				   szQuestion);

	// Display the message box with the question.
	//...........................................
	iResult = MessageBoxProc(hMainWindow,(UINT)szTitle,(UINT)szOutBuff,
							 MB_YESNOCANCEL | MB_ICONQUESTION | MB_HELP,MB_ICONQUESTION,0);
	if (iResult == IDCANCEL)
	{
		bResult = FALSE;
		goto ExtractEnd;
	}
	else if (iResult == IDNO)
	{
		bResult = TRUE;
		goto ExtractEnd;
	}
	// Yes, we really want to extract this key. Get a name and
	// directory to place the key in. Extension of key will be
	// added by the program.
	//........................................................
	InitializeOFN(&ofn,SAVE_DESTINATION);

	// Initialize with specific information for getting a name to
	// save a key in.
	//...........................................................
	ofn.lpstrFile = szOutBuff;
	ofn.nMaxFile = MAX_PATH;
	ofn.hwndOwner = hMainWindow;
	ofn.lpstrFilter = TEXT("Key File [.rsakey]\0*.rsakey\0All Files [*.*]\0*.*\0");
	ofn.nFilterIndex = 1;

	if (TypeKey == PUBLIC_KEY)
	{
		ofn.lpstrTitle = TEXT("Save Extracted Public Key As");
	}
	else
	{
		ofn.lpstrTitle = TEXT("Save Extracted Secret Key As");
	}

	ofn.Flags = (OFN_EXPLORER | OFN_PATHMUSTEXIST | OFN_ENABLEHOOK | 
				 OFN_ENABLESIZING | OFN_SHOWHELP | OFN_HIDEREADONLY);
	ofn.lpstrDefExt = TEXT("rsakey");
	ofn.lpfnHook = MyOFNHookProc;
	
	// Set the icon to use in the caption bar.
	//........................................
	lpIconPointer = lpszAppName;

	while(TRUE)
	{
		// Zero the return string for the file name. Use szOutBuff.
		//.........................................................
		ZeroMemory(&szOutBuff,sizeof(szOutBuff));

		// Get the name and path we want to use for our key file.
		//.......................................................
		if (!GetSaveFileName(&ofn))
		{
			CommDlgBoxErrorProc(IDS_SAVE_AS);
			bResult = FALSE;
			goto ExtractEnd;
		}
		// Save the dir name.
		//...................
		SaveDirName((LPBYTE)&szOutBuff,SAVE_DESTINATION,TRUE);

		hSearch = FindFirstFile((LPCTSTR)&szOutBuff,&wfd);

		if (hSearch == INVALID_HANDLE_VALUE)
		{
			break;
		}
		EmptyTheMessageQue();

		// The file exists, warn the user so he can enter another
		// file name.
		//.......................................................
		FindClose(hSearch);
		SetLastError(IDS_ALREADYEXISTS);
		ErrorProcedure((LPTSTR)&szOutBuff,IDS_FINDFIRSTFILE,MB_OK);
	}
	// Create the new key file.
	//.........................
	hKeyFile = CreateMyFile((LPTSTR)&szOutBuff,GENERIC_READ | GENERIC_WRITE,0,NULL,
						     CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hKeyFile)
	{
		bResult = TRUE;
		goto ExtractEnd;
	}
	// If we have a public key we have to set all the trust
	// packets to not initialized. Except the owner trust 
	// disabled bit.
	//.....................................................
	if (TypeKey == PUBLIC_KEY)
	{
		lpKeyBufferDup1 = lpKeyBuffer1;

		while(TRUE)
		{
			// Check for end of the key.
			//..........................
			if (*lpKeyBufferDup1 == 0)
			{
				break;
			}

			__asm
			{
				mov		edi,lpKeyBufferDup1
				mov		al,byte ptr [edi]
				mov		cl,al
				mov		dwCtb_Byte,ecx
				and		al,CTB_MASK
				mov		HoldPacket,al
				mov		TempCTB,al
			}
			if (TempCTB != CTB_TRUST)
			{
				GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

				__asm
				{
					mov		edi,lpKeyBufferDup1
					add		edi,CTB_SIZE
					add		edi,edx
					add		edi,eax
					mov		lpKeyBufferDup1,edi
				}
			}
			else
			{
				// Set all trust bytes to not initialized, except if
				// key is disabled. Leave disabled bit set in owner
				// trust packet.
				//..................................................
				GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

				__asm
				{
					mov		edi,lpKeyBufferDup1
					add		edi,CTB_SIZE
					add		edi,edx
					mov		lpTrustPacket,edi
					add		edi,eax
					mov		lpKeyBufferDup1,edi
				}
				if (PreviousPacket == CTB_PUBLIC_KEY)
				{
					__asm
					{
						mov		edi,lpTrustPacket
						and		byte ptr [edi],DISABLED_BIT
					}
				}
				else
				{
					__asm
					{
						mov		edi,lpTrustPacket
						mov		byte ptr [edi],NOT_INITIALIZED
					}
				}
			}
			PreviousPacket = HoldPacket;
		}
	}
	// Write the extracted key to disk and close the file.
	//....................................................
	bResult = WriteMyFile((LPTSTR)&szOutBuff,hKeyFile,lpKeyBuffer1,
						   dwRecordLength1,&dwBytesWritten,NULL);
	if (!bResult)
	{
		goto ExtractEnd;
	}
	bResult = CloseMyHandle((LPTSTR)&szOutBuff,hKeyFile);

	ExtractEnd:
	return(bResult);
}

// Issue a compromise certificate on a public key.
// Returns FALSE for error or cancel.
//................................................
BOOL IssueCompromiseCertificate()
{
	LARGE_INTEGER	li;
	DWORD			dwCtb_Byte;
	BOOL			bResult = FALSE;
	int				iResult;
	int				iSetupResult;
	int				iCompareResult;
	DWORD			dwBytesRead;
	DWORD			dwBytesWritten;
	DWORD			dwTailLength;
	TCHAR			szTitle[32];
	TCHAR			szQuestion[200];
	TCHAR			szOutBuff[1024];
	TCHAR			szNewMessage[64];
	BYTE			TempCTB;

	// If this is the universal key only allow the administrator can issue a
	// compromise certificate.
	//.......................................................................
	if (bAa && bRestrictionsInEffect)
	{
		iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&cfg.V1.V2,KEY_ID_SIZE,
									  (LPCTSTR)&CDLine.KEY_SIG_ID,KEY_ID_SIZE);
		if (iCompareResult == CSTR_EQUAL)
		{
			CheckEditError(IDS_ISSUECOMPKEY,(LPBYTE)&CDLine.ID,NULL,
						   IDS_ONLYADMINCOMP,IDS_ADMIN_SKIPPED,
					       MB_ICONHAND | MB_OK,MB_ICONHAND,0);

			bResult = TRUE;
			goto CompEnd;
		}
	}
	// Setup the message box and ask if we really want to issue
	// a compromise certificate.
	//.........................................................
	LoadString(hInst,IDS_ISSUECOMPKEY,szTitle,sizeof(szTitle));
	LoadString(hInst,IDS_ISSUECOMPMSG,szQuestion,sizeof(szQuestion));

	// Format the output for the message box.
	//.......................................
	StringCbPrintf(szOutBuff,sizeof(szOutBuff),TEXT("User ID: %s \n\n%s"),CDLine.ID,
				   szQuestion);

	// Display the message box with the question.
	//...........................................
	iResult = MessageBoxProc(hMainWindow,(UINT)szTitle,(UINT)szOutBuff,
							 MB_YESNOCANCEL | MB_ICONQUESTION | MB_HELP,MB_ICONQUESTION,0);
	if (iResult == IDCANCEL)
	{
		goto CompEnd;
	}
	else if (iResult == IDNO)
	{
		bResult = TRUE;
		goto CompEnd;
	}
	// We really want to issue a compromise certificate.
	// Setup to issue the compromise certificate.
	//..................................................
	CopyMemory(&TempUserId,CDLine.ID,sizeof(CDLine.ID));
	iSetupResult = SignSetup(lpKeyBuffer1,IDS_NOISSUECOMP,IDS_INVALIDCOMPPP);
	// System error.
	//..............
	if (iSetupResult == -1)
	{
		goto CompEnd;
	}
	// No pass word.
	//..............
	if (iSetupResult == 0)
	{
		bResult = TRUE;
		goto CompEnd;
	}
	// We need to get the public key. Setup the key id for
	// the signature too.
	//....................................................
	CopyMemory(&KeySID,&CDLine.KEY_SIG_ID,KEY_ID_SIZE);
	
	// Find the public key.
	//.....................
	li.QuadPart = SearchMyFileBinary((LPBYTE)&szPublicRingKeyId,&KeySID,
									  KEY_ID_SIZE,hPublicRingKeyId,0,&KeyIdSearch);
	if (li.QuadPart == -1)
	{
		goto CompEnd;
	}
	// We did not have a match. Say so and continue with the
	// next key.
	//............................................
	if (li.QuadPart == 0)
	{
		// No matching public key found to issue a compromise
		// certificate for.
		//...................................................
		CheckEditError(IDS_EDITSECRETKEY,(LPBYTE)&CDLine.ID,NULL,
					   IDS_MATCHPUBKEYNOTFOUND,IDS_NOCOMPROMISEISSUED,
					   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
		bResult = TRUE;
		goto CompEnd;
	}
	// We had a match. Temporarily setup group two for 
	// public key with key id index.
	//................................................
	SetUpGroup(PUBLIC_KEY,INDEX_KEY,GROUP_TWO);

	dwIdxOffset2 = li.HighPart;
	dwBytesRead = ReadIndex2();
	if (dwBytesRead == -1)
	{
		goto CompEnd;
	}
	dwBytesRead = ReadRecord2();
	if (dwBytesRead == -1)
	{
		goto CompEnd;
	}
	// Reset group two to public key with user id index.
	//..................................................
	SetUpGroup(PUBLIC_KEY,INDEX_UID,GROUP_TWO);

	CopyMemory(lpKeyBuffer1,lpKeyBuffer2,SIZE_KEY_BUFF);
	CopyMemory(&CDLine1,&CDLine,sizeof(CDLine));

	// We cannot modify the same key twice in the same pass.
	//......................................................
	if (*lpKeyBuffer1 & DELETED_BIT)
	{
		CheckEditError(IDS_EDITSECRETKEY,(LPBYTE)&CDLine.ID,NULL,
					   IDS_NOMODIFYTWICE,IDS_NOCOMPROMISEISSUED,
					   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
		goto CompEnd;
	}
	// Setup dwPublicComp with the size of the public key packet.
	// Contrary to documentation, include the CTB byte and length
	// field.
	//...........................................................
	lpKeyBufferDup1 = lpKeyBuffer1;

	__asm
	{
		mov		edi,lpKeyBufferDup1
		mov		cl,byte ptr [edi]
		mov		dwCtb_Byte,ecx
	}
	GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

	__asm
	{
		push	eax
		add		eax,edx
		add		eax,CTB_SIZE
		mov		dwPublicComp,eax
		pop		eax

		// Check to see if we have already issued a compromise
		// certificate for this public key. Get the first
		// packet after the owner trust packet.
		//....................................................
		mov		edi,lpKeyBufferDup1
		add		edi,CTB_SIZE
		add		edi,edx
		add		edi,eax
		mov		lpKeyBufferDup1,edi
		mov		cl,byte ptr [edi]
		mov		dwCtb_Byte,ecx
	}
	GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

	__asm
	{
		mov		edi,lpKeyBufferDup1
		add		edi,CTB_SIZE
		add		edi,edx
		add		edi,eax
		mov		al,byte ptr [edi]
		and		al,CTB_MASK
		mov		TempCTB,al
	}
	// If the first packet after the owner trust packet is a
	// signature packet, it can only be a compromise certificate.
	//...........................................................
	if (TempCTB == CTB_SKE_PACKET)
	{
		CheckEditError(IDS_EDITPUBLICKEY,(LPBYTE)&CDLine.ID,
					  (LPBYTE)&CDLine.ID,IDS_PUBKEYALREADYCOMP,IDS_NOCOMPROMISEISSUED,
					   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
		bResult = TRUE;
		goto CompEnd;
	}
	// Setup the skip counters for the CheckForMessages function.
	//...........................................................
	__asm
	{
		mov		iSkipCounter,250
		mov		iInitialSkipValue,250
	}
	// We are go for creating the compromise certificate.
	//...................................................
	bCancelOperation = FALSE;
	uiCalcsMessage = IDS_COMPCALCS;
	hDialogModeLess = CreateDialog(hInst,TEXT("SIGNATURECALCULATIONS"),
								   hMainWindow,(DLGPROC)SignatureCalcsProc);
	
	if (!hDialogModeLess)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto CompEnd;
	}
	// Create the key compromise certificate, which is returned in
	// lpKeyBuffer2.
	//............................................................
	SignMyKey(KEY_COMPROMISE);

	EmptyTheMessageQue();

	if (bCancelOperation)
	{
		bResult = TRUE;
		goto CompEnd;
	}
	FlashMyIcon(TRUE);

	// Change the cancel button to OK.
	//................................
	SetDlgItemText(hDialogModeLess,IDCANCEL,TEXT("&OK"));

	// Add the length of the key packet trust packet to dwPublicComp
	// to get the length of the key to write.
	//..............................................................
	__asm
	{
		mov		edi,lpKeyBuffer1
		add		edi,dwPublicComp
		mov		cl,byte ptr [edi]
		mov		dwCtb_Byte,ecx
		mov		lpKeyBufferDup1,edi
	}
	GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

	__asm
	{
		add		eax,edx
		add		eax,CTB_SIZE
		add		dwPublicComp,eax
	}
	// Append the key and trust packet to the end of the
	// public key ring.
	//..................................................
	li.QuadPart = 0;
	li.QuadPart = SetMyFilePointer((LPTSTR)&cfg.szPublicKeyRing,
		                            hPublicKeyRing,li.QuadPart,FILE_END);
	if (li.QuadPart == -1)
	{
		goto CompEnd;
	}
	bResult = WriteMyFile((LPTSTR)&cfg.szPublicKeyRing,hPublicKeyRing,
		                   lpKeyBuffer1,dwPublicComp,&dwBytesWritten,NULL);
	if (!bResult)
	{
		goto CompEnd;
	}
	// Write the signature.
	//.....................
	bResult = WriteMyFile((LPTSTR)&cfg.szPublicKeyRing,hPublicKeyRing,
		                   lpKeyBuffer2,dwSignatureSize,&dwBytesWritten,NULL);
	if (!bResult)
	{
		goto CompEnd;
	}
	// Now append the rest of the public key after the compromise
	// certificate.
	//...........................................................
	__asm
	{
		mov		edi,lpKeyBuffer1
		add		edi,dwPublicComp
		mov		lpKeyBufferDup1,edi
		mov		edx,dwRecordLength2
		sub		edx,dwPublicComp
		mov		dwTailLength,edx
	}
	bResult = WriteMyFile((LPTSTR)&cfg.szPublicKeyRing,hPublicKeyRing,
						   lpKeyBufferDup1,dwTailLength,&dwBytesWritten,NULL);
	if (!bResult)
	{
		goto CompEnd;
	}
	// Mark the original public key for deletion. Swap some ops
	// for the MarkKey1 function.
	//.........................................................
	SwapOps((LPBYTE)&hKeyHandle1,(LPBYTE)&hKeyHandle2,4);
	SwapOps((LPBYTE)&lpRingFile1,(LPBYTE)&lpRingFile2,4);
	SwapOps((LPBYTE)&dwRecordLength1,(LPBYTE)&dwRecordLength2,4);
	SwapOps((LPBYTE)&dwRingFileOffset1,(LPBYTE)&dwRingFileOffset2,4);

	TypeKey = PUBLIC_KEY;
	bResult = MarkKey1(DELETE_IT);

	// Swap the ops back.
	//...................
	SwapOps((LPBYTE)&hKeyHandle1,(LPBYTE)&hKeyHandle2,4);
	SwapOps((LPBYTE)&lpRingFile1,(LPBYTE)&lpRingFile2,4);
	SwapOps((LPBYTE)&dwRecordLength1,(LPBYTE)&dwRecordLength2,4);
	SwapOps((LPBYTE)&dwRingFileOffset1,(LPBYTE)&dwRingFileOffset2,4);

	bWeChangedIt = TRUE;

	// Change the message text to signature calcs completed.
	//......................................................
	LoadString(hInst,IDS_SIGCOMPLETED,(LPTSTR)&szNewMessage,sizeof(szNewMessage));
	SetDlgItemText(hDialogModeLess,IDC_MYMESSAGE,(LPCTSTR)&szNewMessage);

	// Wait for the dialog box to be closed.
	//......................................
	while(TRUE)
	{
		CheckForMessages();

		if (bCancelOperation == TRUE)
		{
			break;
		}
	}	

	CompEnd:

	FlashMyIcon(FALSE);

	bCancelOperation = FALSE;
	TypeKey = SECRET_KEY;

	ClearAllVariables();

	if (hDialogModeLess)
	{
		DestroyWindow(hDialogModeLess);
	}
	return(bResult);
}

BOOL SetOwnerTrust()
{
	BOOL		bResult;
	int			iCompareResult;

	// If this is the universal key only allow the administrator to edit the
	// owner trust.
	//......................................................................
	if (bAa && bRestrictionsInEffect)
	{
		iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&cfg.V1.V2,KEY_ID_SIZE,
									  (LPCTSTR)&CDLine.KEY_SIG_ID,KEY_ID_SIZE);
		if (iCompareResult == CSTR_EQUAL)
		{
			CheckEditError(IDS_EDITPUBLICKEY,(LPBYTE)&CDLine.ID,NULL,
						   IDS_ONLYADMINOWNER,IDS_ADMIN_SKIPPED,
						   MB_ICONHAND | MB_OK,MB_ICONHAND,0);

			return(TRUE);
		}
	}

	bResult = SetTheOwnerTrustByte(EDIT_OWNER_TRUST);

	return(bResult);
}

// Delete signatures from a public key.
// Returns FALSE for error or cancel.
//.....................................
BOOL DeleteSignatures()
{
	LPBYTE		lpSignature;
	DWORD		dwCtb_Byte;
	DWORD		dwCompareResult;
	int			iResult;
	LPCD_STRUCT	lpCentralDir;
	TCHAR		szTitle[24];
	TCHAR		szQuestion[64];
	TCHAR		szOutBuff[1024];
	BOOL		bResult;
	BYTE		TempCTB;

	lpCentralDir = lpScratchCentralDir1;

	// In order to get the user id of the key this signature belongs
	// to, we have to trace back in the central directory to the
	// preceeding public key entry.
	//..............................................................
	while(TRUE)
	{
		// Go back one entry in the cental directory.
		//...........................................
		__asm
		{
			mov		eax,dwCDLength
			sub		lpCentralDir,eax
		}
		if (lpCentralDir->TYPE_KEY == PUBLIC_KEY)
		{
			CopyMemory(&CDLine1,lpCentralDir,dwCDLength);
			break;
		}
	}
	// Get the signature offset for the signature we want to delete.
	// The signature has to be there so we do not look for errors.
	//..............................................................
	lpKeyBufferDup1 = lpKeyBuffer1;

	while(TRUE)
	{
		__asm
		{
			mov		edi,lpKeyBufferDup1
			mov		al,byte ptr [edi]
			mov		cl,al
			mov		dwCtb_Byte,ecx
			and		al,CTB_MASK
			mov		TempCTB,al
		}
		if (TempCTB != CTB_SKE_PACKET)
		{
			GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup1
				add		edi,CTB_SIZE
				add		edi,edx
				add		edi,eax
				mov		lpKeyBufferDup1,edi
			}
		}
		else
		{
			lpSignature = lpKeyBufferDup1;
			GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup1
				add		edi,CTB_SIZE
				add		edi,edx
				mov		lpKeyBufferDup1,edi
				add		lpKeyBufferDup1,eax		// Points to next pckt.
				add		edi,(VERSION_SIZE + 2 + TIMESTAMP_SIZE)
				mov		lpKeyBufferDup2,edi
			}
			dwCompareResult = MpCompareDW(lpKeyBufferDup2,(LPBYTE)&CDLine.KEY_SIG_ID,2);
			if (dwCompareResult == 0)
			{
				break;
			}
		}
	}
	// Setup and display a message box to see if we really want to
	// delete this signature.
	//............................................................
	LoadString(hInst,IDS_EDITPUBLICKEY,szTitle,sizeof(szTitle));
	LoadString(hInst,IDS_DELSIGQUESTION,szQuestion,sizeof(szQuestion));

	// Format all the output for the message box.
	//...........................................
	StringCbPrintf(szOutBuff,sizeof(szOutBuff),
				   TEXT("User ID: %s \n\nSignature ID: %s \n\n%s"),
				   CDLine1.ID,CDLine.ID,szQuestion);

	// Display the message box with the question.
	//...........................................
	iResult = MessageBoxProc(hMainWindow,(UINT)szTitle,(UINT)szOutBuff,
							 MB_YESNOCANCEL | MB_ICONQUESTION | MB_HELP,MB_ICONQUESTION,0);
	if (iResult == IDCANCEL)
	{
		bResult = FALSE;
		goto DelSigEnd;
	}
	else if (iResult == IDNO)
	{
		bResult = TRUE;
		goto DelSigEnd;
	}
	// We want to delete the signature. Mark the signature and
	// trust packet for deletion.
	//........................................................
	__asm
	{
		mov		edi,lpSignature
		mov		cl,byte ptr [edi]
		mov		dwCtb_Byte,ecx
		or		byte ptr [edi],DELETED_BIT
	}
	GetPcktLength(lpSignature,dwCtb_Byte);

	__asm
	{
		mov		edi,lpSignature
		add		edi,CTB_SIZE
		add		edi,edx
		add		edi,eax
		or		byte ptr [edi],DELETED_BIT
	}
	// Write it back to disk.
	//.......................
	bResult = WriteRecord1();
	if (!bResult)
	{
		goto DelSigEnd;
	}
	dwPublicDeleted++;
	bWeChangedIt = TRUE;

	DelSigEnd:
	return(bResult);
}

// Sign a public key with your secret key.
// Key to sign in lpKeyBuffer1.
// Returns FALSE for error or cancel.
//........................................
BOOL SignAPublicKey()
{
	LARGE_INTEGER	li;
	BOOL			bResult;
	LARGE_INTEGER	liCurrentTimestamp;
	LARGE_INTEGER	liValidityTimestamp;
	DWORD			dwValidityPeriod;
	LPBYTE			lpWhatsLeft;
	LPBYTE			lpTempUserId;
	LPBYTE			lpKeyIdPointer;
	DWORD			dwTempUserIdLength;
	DWORD			dwCompareResult;
	DWORD			dwSavedEditFunction;
	int				iCompareResult;
	int				iDlgResult;
	int				iSetupResult;
	DWORD			dwSignatureType;
	DWORD			dwHeaderLength;
	DWORD			dwTailLength;
	DWORD			dwCtb_Byte;
	DWORD			dwBytesRead;
	DWORD			dwBytesWritten;
	BOOL			bKeyDisabled;
	BOOL			bSignedOnce;
	BOOL			bSignKeyDisabled;
	LPCD_STRUCT		lpCentralDir;
	BYTE			TempCTB;
	TCHAR			szNewMessage[64];

	bKeyDisabled = FALSE;
	bSignedOnce = FALSE;
	bSignKeyDisabled = FALSE;
	bResult = TRUE;

	// Get the current GMT timestamp.
	//...............................
	liCurrentTimestamp.QuadPart = GetTimestamp(TRUE);

	// We cannot sign the same key twice in one pass.
	// This is possible if the key has more than one
	// user id. The DELETED_BIT will be set if already
	// signed once.
	//................................................
	if (*lpKeyBuffer1 & DELETED_BIT)
	{
		bSignedOnce = TRUE;
	}
	// Check the timestamp and validity period to see if the
	// key may be disabled.
	//......................................................
	lpKeyBufferDup1 = lpKeyBuffer1;

	__asm
	{
		mov		edi,lpKeyBufferDup1
		mov		cl,byte ptr [edi]
		mov		dwCtb_Byte,ecx
	}
	GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

	// Setup for getting the validity timestamp.
	//..........................................
	liValidityTimestamp.QuadPart = 0;
	__asm
	{
		mov		edi,lpKeyBufferDup1
		add		edi,CTB_SIZE
		add		edi,edx
		mov		lpKeyBufferDup1,edi
		add		lpKeyBufferDup1,eax		// Point to trust packet.
		add		edi,VERSION_SIZE
		mov		esi,dword ptr [edi]
		bswap	esi
		mov		liValidityTimestamp.LowPart,esi

		// Get the high order 7 bits of the timestamp.
		//............................................
		mov		eax,dword ptr [edi+6]
		and		eax,0x00ff
		shr		eax,1
		mov		liValidityTimestamp.HighPart,eax

		add		edi,TIMESTAMP_SIZE
		movzx	eax,word ptr [edi]
		xchg	ah,al
		mov		dwValidityPeriod,eax
	}
	if (dwValidityPeriod)
	{
		__asm
		{
			xor		edx,edx
			mov		eax,dwValidityPeriod
			mov		ecx,SECS_PER_DAY
			mul		ecx
			add		liValidityTimestamp.LowPart,eax
			adc		liValidityTimestamp.HighPart,edx
		}
		if (liValidityTimestamp.QuadPart < liCurrentTimestamp.QuadPart)
		{
			bKeyDisabled = TRUE;
		}
	}
	// Calculate the length of the public key packet for signature.
	//.............................................................
	dwPublicComp = lpKeyBufferDup1 - lpKeyBuffer1;

	// Check the disabled bit in the trust packet.
	//............................................
	__asm
	{
		mov		edi,lpKeyBufferDup1
		mov		cl,byte ptr [edi]
		mov		dwCtb_Byte,ecx
	}
	GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

	__asm
	{
		mov		edi,lpKeyBufferDup1
		add		edi,CTB_SIZE
		add		edi,edx
		mov		al,byte ptr [edi]
		mov		TempCTB,al
	}
	if (TempCTB & DISABLED_BIT)
	{
		bKeyDisabled = TRUE;
	}
	// Search for the wanted user id.
	//...............................
	while(TRUE)
	{
		__asm
		{
			mov		edi,lpKeyBufferDup1
			mov		al,byte ptr [edi]
			mov		cl,al
			mov		dwCtb_Byte,ecx
			and		al,CTB_MASK
			mov		TempCTB,al
		}
		if (TempCTB != CTB_USER_ID)
		{
			GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup1
				add		edi,CTB_SIZE
				add		edi,edx
				add		edi,eax
				mov		lpKeyBufferDup1,edi
			}
		}
		else
		{
			GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup1
				add		edi,CTB_SIZE
				add		edi,edx
				mov		lpTempUserId,edi
				mov		dwTempUserIdLength,eax
				add		edi,eax
				mov		lpKeyBufferDup1,edi		// Points to trust pckt.
			}
			iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&CDLine.ID,-1,
										   lpTempUserId,dwTempUserIdLength);
			if (iCompareResult == CSTR_EQUAL)
			{
				break;
			}
		}
	}
	// Setup the user id for the signature.
	//.....................................
	ZeroMemory(&szUserID,sizeof(szUserID));
	iLengthOfUserId = dwTempUserIdLength;
	CopyMemory(&szUserID,lpTempUserId,dwTempUserIdLength);

	// Setup the what left pointer and header length. Get past
	// the trust packet after the user id. Our signature will
	// be the first one after the user id.
	//........................................................
	__asm
	{
		mov		edi,lpKeyBufferDup1
		mov		cl,byte ptr [edi]
		mov		dwCtb_Byte,ecx
	}
	GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

	__asm
	{
		mov		edi,lpKeyBufferDup1
		add		edi,CTB_SIZE
		add		edi,edx
		add		edi,eax
		mov		lpWhatsLeft,edi
	}
	dwHeaderLength = lpWhatsLeft - lpKeyBuffer1;
	dwTailLength = dwRecordLength1 - dwHeaderLength;

	// If the key is disabled, say so.
	//................................
	if (bKeyDisabled)
	{
		CheckEditError(IDS_EDITPUBLICKEY,(LPBYTE)&CDLine.ID,NULL,
					   IDS_PUBKEYDISABLED,IDS_KEYIDNOTSIGNED,
					   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
		goto SignKeyEnd;
	}
	// If we have already signed the key once in this pass we
	// cannot do it again.
	//.......................................................
	if (bSignedOnce)
	{
		CheckEditError(IDS_EDITPUBLICKEY,(LPBYTE)&CDLine.ID,NULL,
					   IDS_NOMODIFYTWICE,IDS_KEYIDNOTSIGNED,
					   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
		goto SignKeyEnd;
	}
	// Display the dialog box for getting the type of signature.
	//..........................................................
	iDlgResult = DialogBox(hInst,TEXT("GETSIGNATURETYPE"),hMainWindow,
						  (DLGPROC)GetSignatureTypeProc);

	// See if we had a system error in creating the dialog box.
	//.........................................................
	if (iDlgResult == -1)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto SignKeyEnd;
	}
	// If we closed the dialog box without selecting a type of
	// signature, treat it as skipping this key.
	//........................................................
	if (iDlgResult == IDC_SKIPKEY || iDlgResult == 0)
	{	
		goto SignKeyEnd;
	}
	// Set the signature type depending on the selection.
	//..................................................
	if (iDlgResult == IDC_NOID)
	{
		dwSignatureType = KEY_CERT_PER;
	}
	else if (iDlgResult == IDC_CASUALID)
	{
		dwSignatureType = KEY_CERT_CAS;
	}
	else
	{
		dwSignatureType = KEY_CERT_POS;
	}
	// Select the secret key we want to sign with.
	//............................................
	dwSavedEditFunction = dwEditFunction;
	dwEditFunction = 11;			// Set title of virtual list window.
	bSingleSelectionOnly = TRUE;
	iItemsSelected = 0;
	MarkType = MARK_KEYS;
	iMaxItems = dwSecretIds;
	iItemCount = dwSecretIds;
	lpScratchCentralDir = lpSecretKeyCentralDir;

	// We have to change the key type also. Change it back when done.
	//...............................................................
	TypeKey = SECRET_KEY;

	bResult = MarkTheKeys();
	if (!bResult)
	{
		goto SignKeyEnd;
	}
	// Change variables back to what they should be.
	//..............................................
	TypeKey = PUBLIC_KEY;
	dwEditFunction = dwSavedEditFunction;
	lpScratchCentralDir = lpPublicKeyCentralDir;

	// If we did not select a secret key to sign with, skip this key.
	//...............................................................
	if (iItemsSelected == 0)
	{
		goto SignKeyEnd;
	}
	// Find the secret key we selected.
	//.................................
	lpCentralDir = lpSecretKeyCentralDir;
	while(TRUE)
	{
		if (lpCentralDir->STATE)
		{
			break;
		}
		__asm
		{
			mov		eax,dwCDLength
			add		lpCentralDir,eax
		}
	}
	// Make sure it gets unmarked in case we have to select
	// again from the same central dir.
	//.....................................................
	lpCentralDir->STATE = 0;
	CopyMemory(&CDLine1,lpCentralDir,dwCDLength);

	// We have our marked secret key. Read it into lpKeyBuffer2.
	//..........................................................
	dwIdxOffset2 = lpCentralDir->IDX_OFFS;
	dwBytesRead = ReadIndex2();
	if (dwBytesRead == -1)
	{
		bResult = FALSE;
		goto SignKeyEnd;
	}
	dwBytesRead = ReadRecord2();
	if (dwBytesRead == -1)
	{
		bResult = FALSE;
		goto SignKeyEnd;
	}
	// Check to make sure that this public key user id has not been
	// signed by this secret key. Get the id of the secret key.
	// Setup the key id for the signature too.
	//.............................................................
	CopyMemory(&KeySID,&CDLine1.KEY_SIG_ID,KEY_ID_SIZE);

	// Now look at all the signatures following the user id in the
	// public key to see if we have a match.
	//............................................................
	lpKeyBufferDup1 = lpWhatsLeft;
	while(TRUE)
	{
		// Check for end of key without a match.
		//......................................
		if (*lpKeyBufferDup1 == 0)
		{
			break;
		}

		_asm
		{
			mov		edi,lpKeyBufferDup1
			mov		al,byte ptr [edi]
			mov		cl,al
			mov		dwCtb_Byte,ecx
			and		al,CTB_MASK
			mov		TempCTB,al
		}
		// Next user id without a match.
		//..............................
		if (TempCTB == CTB_USER_ID)
		{
			break;
		}
		if (TempCTB != CTB_SKE_PACKET)
		{
			GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup1
				add		edi,CTB_SIZE
				add		edi,edx
				add		edi,eax
				mov		lpKeyBufferDup1,edi
			}
		}
		else
		{
			GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup1
				add		edi,CTB_SIZE
				add		edi,edx
				mov		lpKeyBufferDup1,edi
				add		lpKeyBufferDup1,eax
				add		edi,(VERSION_SIZE + 2 + TIMESTAMP_SIZE)
				mov		lpKeyIdPointer,edi
			}
			// If we have a match say so, and then return.
			//............................................
			dwCompareResult = MpCompareDW(lpKeyIdPointer,&KeySID,2);
			if (dwCompareResult == 0)
			{
				CheckEditError(IDS_EDITPUBLICKEY,(LPBYTE)&CDLine.ID,
							  (LPBYTE)&CDLine1.ID,IDS_PUBKEYALREADYSIGNED,
							   IDS_KEYIDNOTSIGNED,MB_ICONHAND | MB_OK,MB_ICONHAND,0);
				goto SignKeyEnd;
			}
		}
	}		
	// We can sign this key. Setup the secret components.
	//...................................................
	CopyMemory(&TempUserId,&CDLine1.ID,sizeof(CDLine1.ID));
	iSetupResult = SignSetup(lpKeyBuffer2,IDS_NOSIGNPUBKEY,IDS_INVALIDSIGNPP);
	// System error.
	//..............
	if (iSetupResult == -1)
	{
		bResult = FALSE;
		goto SignKeyEnd;
	}
	// No pass word.
	//..............
	if (iSetupResult == 0)
	{
		goto SignKeyEnd;
	}
	// See if we are signing our own public key. If so change the
	// signature type to self-signed.
	//...........................................................
	iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&CDLine.KEY_SIG_ID,8,
								  (LPCTSTR)&CDLine1.KEY_SIG_ID,8);
	if (iCompareResult == CSTR_EQUAL)
	{
		dwSignatureType = KEY_CERT_SELF;
	}
	// Get the matching public key and see if it, along with the
	// secret key has been disabled. We do not sign keys with our
	// our disabled keys.
	//...........................................................
	li.QuadPart = SearchMyFileBinary((LPBYTE)&szPublicRingKeyId,&KeySID,
									  KEY_ID_SIZE,hPublicRingKeyId,0,&KeyIdSearch);
	if (li.QuadPart == -1)
	{
		bResult = FALSE;
		goto SignKeyEnd;
	}
	// We had a match. See if the key is disabled.
	//............................................
	if (li.QuadPart != 0)
	{
		// Temporarily change group two to public key with
		// key id index.
		//................................................
		SetUpGroup(PUBLIC_KEY,INDEX_KEY,GROUP_TWO);

		dwIdxOffset2 = li.HighPart;
		dwBytesRead = ReadIndex2();
		if (dwBytesRead == -1)
		{
			bResult = FALSE;
			goto SignKeyEnd;
		}
		dwBytesRead = ReadRecord2();
		if (dwBytesRead == -1)
		{
			bResult = FALSE;
			goto SignKeyEnd;
		}
		// Reset group two to secret key using user id index.
		//...................................................
		SetUpGroup(SECRET_KEY,INDEX_UID,GROUP_TWO);

		// The public key is in lpKeyBuffer2.
		//...................................
		lpKeyBufferDup1 = lpKeyBuffer2;

		// Check the timestamp and validity to see if the key
		// is disabled, which means our secret key is disabled.
		//.....................................................
		__asm
		{
			mov		edi,lpKeyBufferDup1
			mov		cl,byte ptr [edi]
			mov		dwCtb_Byte,ecx
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		// Setup for getting the validity timestamp.
		//..........................................
		liValidityTimestamp.QuadPart = 0;
		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			mov		lpKeyBufferDup1,edi
			add		lpKeyBufferDup1,eax		// Point to trust packet.
			add		edi,VERSION_SIZE
			mov		esi,dword ptr [edi]
			bswap	esi
			mov		liValidityTimestamp.LowPart,esi

			// Get the high 7 bits of the timestamp.
			//......................................
			mov		eax,dword ptr [edi+6]
			and		eax,0x00ff
			shr		eax,1
			mov		liValidityTimestamp.HighPart,eax

			add		edi,TIMESTAMP_SIZE
			movzx	eax,word ptr [edi]
			xchg	ah,al
			mov		dwValidityPeriod,eax
		}
		if (dwValidityPeriod)
		{
			__asm
			{
				xor		edx,edx
				mov		eax,dwValidityPeriod
				mov		ecx,SECS_PER_DAY
				mul		ecx
				add		liValidityTimestamp.LowPart,eax
				adc		liValidityTimestamp.HighPart,edx
			}
			if (liValidityTimestamp.QuadPart < liCurrentTimestamp.QuadPart)
			{
				bSignKeyDisabled = TRUE;
			}
		}
		// Check the disabled bit in the trust packet.
		//............................................
		__asm
		{
			mov		edi,lpKeyBufferDup1
			mov		cl,byte ptr [edi]
			mov		dwCtb_Byte,ecx
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			mov		al,byte ptr [edi]
			mov		TempCTB,al
		}
		if (TempCTB & DISABLED_BIT)
		{
			bSignKeyDisabled = TRUE;
		}
	}
	// If the key is disabled, say so and exit.
	//.........................................
	if (bSignKeyDisabled)
	{
		CheckEditError(IDS_EDITPUBLICKEY,(LPBYTE)&CDLine.ID,
					  (LPBYTE) &CDLine1.ID,IDS_SECKEYSIGNDISABLED,
					   IDS_KEYIDNOTSIGNED,MB_ICONHAND | MB_OK,MB_ICONHAND,0);
		goto SignKeyEnd;
	}
	// Setup the skip counters for the CheckForMessages function.
	//...........................................................
	__asm
	{
		mov		iSkipCounter,250
		mov		iInitialSkipValue,250
	}
	// We are go for signing the key. Display a modleless dialog box
	// with a cancel button for cancelling the procedure. On large
	// keys this could take awhile.
	//..............................................................
	bCancelOperation = FALSE;
	uiCalcsMessage = IDS_SIGCALCS;
	hDialogModeLess = CreateDialog(hInst,TEXT("SIGNATURECALCULATIONS"),
								   hMainWindow,(DLGPROC)SignatureCalcsProc);
	if (!hDialogModeLess)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto SignKeyEnd;
	}
	// Sign the key.
	//..............
	SignMyKey(dwSignatureType);

	EmptyTheMessageQue();

	if (bCancelOperation)
	{
		bResult = TRUE;
		goto SignKeyEnd;
	}
	FlashMyIcon(TRUE);

	// Change the cancel button to OK.
	//................................
	SetDlgItemText(hDialogModeLess,IDCANCEL,TEXT("&OK"));

	// Write the parts of the key, with the added signature to disk.
	//..............................................................
	li.QuadPart = 0;
	li.QuadPart = SetMyFilePointer((LPTSTR)&cfg.szPublicKeyRing,
		                            hPublicKeyRing,li.QuadPart,FILE_END);
	if (li.QuadPart == -1)
	{
		bResult = FALSE;
		goto SignKeyEnd;
	}
	bResult = WriteMyFile((LPTSTR)&cfg.szPublicKeyRing,hPublicKeyRing,
		                   lpKeyBuffer1,dwHeaderLength,&dwBytesWritten,NULL);
	if (!bResult)
	{
		goto SignKeyEnd;
	}
	// Write the signature.
	//.....................
	bResult = WriteMyFile((LPTSTR)&cfg.szPublicKeyRing,hPublicKeyRing,
		                   lpKeyBuffer2,dwSignatureSize,&dwBytesWritten,NULL);
	if (!bResult)
	{
		goto SignKeyEnd;
	}
	// Now write the rest of the key if any.
	//......................................
	if (dwTailLength)
	{
		bResult = WriteMyFile((LPTSTR)&cfg.szPublicKeyRing,hPublicKeyRing,
							   lpWhatsLeft,dwTailLength,&dwBytesWritten,NULL);
		if (!bResult)
		{
			goto SignKeyEnd;
		}
	}
	// Mark the original key for deletion.
	//....................................
	bResult = MarkKey1(DELETE_IT);
	if (!bResult)
	{
		goto SignKeyEnd;
	}
	bWeChangedIt = TRUE;

	// Change the message text to signature calcs completed.
	//......................................................
	LoadString(hInst,IDS_SIGCOMPLETED,(LPTSTR)&szNewMessage,sizeof(szNewMessage));
	SetDlgItemText(hDialogModeLess,IDC_MYMESSAGE,(LPCTSTR)&szNewMessage);

	// Wait for the dialog box to be closed.
	//......................................
	while(TRUE)
	{
		CheckForMessages();

		if (bCancelOperation == TRUE)
		{
			break;
		}
	}	

	SignKeyEnd:

	FlashMyIcon(FALSE);

	bCancelOperation = FALSE;

	ClearAllVariables();

	if (hDialogModeLess)
	{
		DestroyWindow(hDialogModeLess);
	}
	return(bResult);
}

// CALLBACK procedure for the signature calculations dialog box.
// Type of signature calculations in uiCalcsMessage.
//..............................................................
LRESULT CALLBACK SignatureCalcsProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	TCHAR		szCalcsBuffer[128];

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			SetBoldFont(hDlg,IDC_MYMESSAGE,0);

			// Display the public and secret key ids.
			//.......................................
			SetDlgItemTextFmt(hDlg,IDC_PUBKEYID,(LPCTSTR)&CDLine.ID);
			SetDlgItemTextFmt(hDlg,IDC_SECKEYID,(LPCTSTR)&CDLine1.ID);

			// Display the type of signature we are making.
			//.............................................
			LoadString(hInst,uiCalcsMessage,szCalcsBuffer,sizeof(szCalcsBuffer));
			SetDlgItemText(hDlg,IDC_SIGTYPEMSG,szCalcsBuffer);

			// Inform that signature calculations could take awhile.
			//......................................................
			LoadString(hInst,IDS_SIGSTAKEAWHILE,(LPTSTR)&szCalcsBuffer,sizeof(szCalcsBuffer));
			SetDlgItemText(hDlg,IDC_MYMESSAGE,(LPCTSTR)&szCalcsBuffer);

			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDCANCEL));
			return(FALSE);
		}

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				// Inform the procedure that we want to quit.
				//...........................................
				case IDCANCEL:
				{
					bCancelOperation = TRUE;
				}
				break;
			}
		}
		break;

		case WM_DESTROY:
		{
			if (hDlgFont)
			{
				DeleteObject(hDlgFont);
				hDlgFont = 0;
			}
			hDialogModeLess = NULL;
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// CALLBACK procedure for the select type of signature dialog box.
//................................................................
LRESULT CALLBACK GetSignatureTypeProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	int			iMessageBoxResult;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Set the user id.
			//..................
			SetDlgItemTextFmt(hDlg,IDC_SIGNUSER,(LPCTSTR)&CDLine.ID);

			// Center the window.
			//...................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_NOID:
				{
					EndDialog(hDlg,IDC_NOID);
				}
				break;

				case IDC_CASUALID:
				{
					EndDialog(hDlg,IDC_CASUALID);
				}
				break;

				case IDC_POSITIVEID:
				{
					EndDialog(hDlg,IDC_POSITIVEID);
				}
				break;

				case IDC_SKIPKEY:
				{
					EndDialog(hDlg,IDC_SKIPKEY);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_CLOSE:
		{
			iMessageBoxResult = MessageBoxProc(hDlg,IDS_QUESTION,IDS_NOSIGTYPEPICKED,
											   MB_ICONQUESTION | MB_YESNO,
											   MB_ICONQUESTION,0);
			if (iMessageBoxResult == IDYES)
			{
				EndDialog(hDlg,0);
			}
			return(0);
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;
	
		default:
			return(FALSE);
	}
	return(TRUE);
}

// Disable or enable a public key.
// Returns FALSE for error or cancel.
//...................................
BOOL DisableAKey()
{
	BOOL		bResult;
	int			iResult;
	int			iCompareResult;
	LPBYTE		lpOwnerTrustByte;
	BOOL		bKeyDisabled;
	DWORD		dwCtb_Byte;
	UINT		uiTempQuestion;
	TCHAR		szTitle[24];
	TCHAR		szQuestion[128];
	TCHAR		szOutBuff[1024];
	BYTE		OwnerTrustByte;

	bKeyDisabled = FALSE;
	lpKeyBufferDup1 = lpKeyBuffer1;

	// If this is the universal key only allow the administrator to delete it.
	//........................................................................
	if (bAa && bRestrictionsInEffect)
	{
		iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&cfg.V1.V2,KEY_ID_SIZE,
									  (LPCTSTR)&CDLine.KEY_SIG_ID,KEY_ID_SIZE);
		if (iCompareResult == CSTR_EQUAL)
		{
			CheckEditError(IDS_EDITPUBLICKEY,(LPBYTE)&CDLine.ID,NULL,
						   IDS_ONLYADMINDISABL,IDS_ADMIN_SKIPPED,
						   MB_ICONHAND | MB_OK,MB_ICONHAND,0);

			bResult = TRUE;
			goto DisableEnd;
		}
	}
	// Check to see if the key is disabled or not.
	//............................................
	__asm
	{
		mov		edi,lpKeyBufferDup1
		mov		cl,byte ptr [edi]
		mov		dwCtb_Byte,ecx
	}

	GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

	__asm
	{
		mov		edi,lpKeyBufferDup1
		add		edi,CTB_SIZE
		add		edi,edx
		add		edi,eax
		mov		cl,byte ptr [edi]
		mov		dwCtb_Byte,ecx
		mov		lpKeyBufferDup1,edi
	}
	// The next packet is the owner trust and tells us
	// if the key is disabled or not. Save the offset
	// in case we have to change it.
	//................................................
	GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

	__asm
	{
		mov		edi,lpKeyBufferDup1
		add		edi,CTB_SIZE
		add		edi,edx
		mov		lpOwnerTrustByte,edi
		mov		al,byte ptr [edi]
		mov		OwnerTrustByte,al
	}
	if (OwnerTrustByte & DISABLED_BIT)
	{
		bKeyDisabled = TRUE;
	}
	// Set up the message box which asks if we really want to disable
	// or enable this key.
	//...............................................................
	if (bKeyDisabled)
	{
		uiTempQuestion = IDS_PUBKEYENABLE;
	}
	else
	{
		uiTempQuestion = IDS_PUBKEYDISABLE;
	}
	LoadString(hInst,IDS_EDITPUBLICKEY,szTitle,sizeof(szTitle));
	LoadString(hInst,uiTempQuestion,szQuestion,sizeof(szQuestion));

	// Format all the output for the message box.
	//...........................................
	StringCbPrintf(szOutBuff,sizeof(szOutBuff),TEXT("User ID: %s \n\n%s"),CDLine.ID,
				   szQuestion);

	// Display the message box with the question.
	//...........................................
	iResult = MessageBoxProc(hMainWindow,(UINT)szTitle,(UINT)szOutBuff,
							 MB_YESNOCANCEL | MB_ICONQUESTION | MB_HELP,MB_ICONQUESTION,0);
	if (iResult == IDCANCEL)
	{
		bResult = FALSE;
		goto DisableEnd;
	}
	else if (iResult == IDNO)
	{
		bResult = TRUE;
		goto DisableEnd;
	}
	// Yes, we want to change the status of this key.
	//...............................................
	__asm
	{
		mov		edi,lpOwnerTrustByte
		xor		byte ptr [edi],DISABLED_BIT
	}
	// Write it back to disk.
	//.......................
	bResult = WriteRecord1();
	if (!bResult)
	{
		goto DisableEnd;
	}
	bKeysEdited = TRUE;
	bWeChangedIt = TRUE;

	DisableEnd:
	return(bResult);
}

// Setup p, q, d, u, e, and n bytes for use by the SignMyKey
// procedures. e is used by the diary procedure.
//
// Entry: User ID in TempUserId.
//
// Exit: TRUE if no error, FALSE if error or no pass word.
//..........................................................
int SignSetup(LPBYTE lpSecretKey, UINT uiPassPhraseMsg, UINT uiInvalidPP)
{
	int			iResult = 0;
	LPBYTE		lpEncipherPtr;
	LPBYTE		lpSecretKey1;
	DWORD		dwKeyLength;
	DWORD		dwCtb_Byte;
	int			iDlgResult;
	DWORD		dwBytesToEncipher;
	DWORD		dwCheckSum;

	ClearAllVariables();
	lpSecretKey1 = lpSecretKey;

	// First get the number of bytes and bits in modulus n
	// and store them.
	//....................................................
	__asm
	{
		mov		edi,lpSecretKey1
		mov		cl,byte ptr [edi]
		mov		dwCtb_Byte,ecx
	}
	GetPcktLength(lpSecretKey1,dwCtb_Byte);

	__asm
	{
		mov		edi,lpSecretKey1
		add		edi,CTB_SIZE
		add		eax,edx
		add		eax,CTB_SIZE
		mov		dwKeyLength,eax
		add		edi,edx
		add		edi,(VERSION_SIZE + TIMESTAMP_SIZE + VALIDITY_SIZE + ALGORITHM_SIZE)
		movzx	ecx,word ptr [edi]
		add		edi,MPI_PREFIX_SIZE
		xchg	ch,cl
		mov		dwN_Bits,ecx
		add		ecx,7
		shr		ecx,3
		mov		dwN_Bytes,ecx
		push	edi
		push	ecx
		mov		esi,edi
		mov		edi,offset Modulus_N
		rep		movsb
		pop		ecx
		pop		edi
		add		edi,ecx

		// Setup exponent e.
		//..................
		movzx	ecx,word ptr [edi]
		add		edi,MPI_PREFIX_SIZE
		xchg	ch,cl
		add		ecx,7
		shr		ecx,3
		mov		dwE_Bytes,ecx
		push	edi
		push	ecx
		mov		esi,edi
		mov		edi,offset E_Temp
		rep		movsb
		pop		ecx
		pop		edi
		add		edi,ecx
		mov		lpEncipherPtr,edi
		add		edi,ALGORITHM_SIZE
		mov		lpSecretKey1,edi
	}
	// See if the secret components are encrypted or not.
	//...................................................
	if (*lpEncipherPtr == TSC_ALGORITHM)
	{
		lpEncipherPtr += (CFB_LENGTH + 1);
		lpSecretKey1 += CFB_LENGTH;

			// Length of enciphered secret components equals
			// total length of the secret key minus the offset
			// of the first byte of the secret components. This
			// includes mpi prefixes and checksum.
			//.................................................
			__asm
			{
				mov		eax,lpSecretKey
				add		eax,dwKeyLength
				sub		eax,lpEncipherPtr
				mov		dwBytesToEncipher,eax
			}
			// Setup the message in case we elect not to enter
			// the password.
			//................................................
			uiGetPassPhraseMsg = uiPassPhraseMsg;
			CopyMemory(lpKeyBuffer3,lpSecretKey,SIZE_KEY_BUFF);

			while(TRUE)
			{
				iDlgResult = DialogBox(hInst,TEXT("GETCURRENTPASSPHRASE"),
									   hMainWindow,(DLGPROC)GetCurrentPassPhraseProc);
				EmptyTheMessageQue();

				// See if we had a system error in creating the 
				// dialog box.
				//.............................................
				if (iDlgResult == -1)
				{
					ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
					iResult = -1;
					goto SignEnd;
				}
				// If we did not enter a pass phrase, or we do not know
				// the pass phrase, return FALSE.
				//.....................................................
				if (iDlgResult == IDCANCEL)
				{
					goto SignEnd;
				}
				// We entered a pass phrase, see if it is the right one.
				//......................................................
				DecipherSecretComponents((LPBYTE)&szPassPhrase1,lpEncipherPtr,
										  iLengthOfPassPhrase,dwBytesToEncipher);

				EmptyTheMessageQue();

				// Do the checksum on the secret components.
				//..........................................
				dwCheckSum = CheckSum(lpEncipherPtr,(dwBytesToEncipher-2));

				__asm
				{
					mov		edi,lpEncipherPtr
					mov		ebx,dwBytesToEncipher
					sub		ebx,2
					movzx	eax,word ptr [edi][ebx]
					xchg	ah,al
					mov		edx,dwCheckSum
					cmp		eax,edx
					je		ExtractSecretComponents
				}
				// An invalid pass phrase was entered. Say so.
				//............................................
				CopyMemory(lpSecretKey,lpKeyBuffer3,SIZE_KEY_BUFF);
				MessageBoxProc(hMainWindow,IDS_INPUT_ERROR,uiInvalidPP,MB_ICONHAND | MB_OK,
							   MB_ICONHAND,0);
			}
	}
	// Extract secret components d, p, q, and u.
	// lpSecretKey1 points to d MPI.
	//..........................................
	ExtractSecretComponents:
	__asm
	{
		mov		esi,lpSecretKey1
		movzx	ecx,word ptr [esi]
		add		esi,MPI_PREFIX_SIZE
		xchg	ch,cl
		add		ecx,7
		shr		ecx,3
		mov		dwD_Bytes,ecx
		push	esi
		push	ecx
		mov		edi,offset D_Temp
		rep		movsb
		pop		ecx
		pop		esi
		add		esi,ecx

		// Transfer prime p.
		//..................
		movzx	ecx,word ptr [esi]
		add		esi,MPI_PREFIX_SIZE
		xchg	ch,cl
		add		ecx,7
		shr		ecx,3
		mov		dwP_Bytes,ecx
		push	esi
		push	ecx
		mov		edi,offset Prime_P
		rep		movsb
		pop		ecx
		pop		esi
		add		esi,ecx

		// Transfer prime q.
		//..................
		movzx	ecx,word ptr [esi]
		add		esi,MPI_PREFIX_SIZE
		xchg	ch,cl
		add		ecx,7
		shr		ecx,3
		mov		dwQ_Bytes,ecx
		push	esi
		push	ecx
		mov		edi,offset Prime_Q
		rep		movsb
		pop		ecx
		pop		esi
		add		esi,ecx

		// Transfer inverse u.
		//....................
		movzx	ecx,word ptr [esi]
		add		esi,MPI_PREFIX_SIZE
		xchg	ch,cl
		add		ecx,7
		shr		ecx,3
		mov		dwU_Bytes,ecx
		mov		edi,offset U_Temp
		rep		movsb
	}
	// Circle swap the variables.
	//...........................
	CircleSwap(&D_Temp,dwD_Bytes);
	CircleSwap(&Prime_P,dwP_Bytes);
	CircleSwap(&Prime_Q,dwQ_Bytes);
	CircleSwap(&U_Temp,dwU_Bytes);
	CircleSwap(&Modulus_N,dwN_Bytes);
	CircleSwap(&E_Temp,dwE_Bytes);
	ZeroMemory(&szPassPhrase1,sizeof(szPassPhrase1));

	iResult = 1;
	SignEnd:
	return(iResult);
}
